/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.decorators;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.decorators.Decorator;
import org.graylog2.decorators.DecoratorService;
import org.graylog2.plugin.decorators.SearchResponseDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DecoratorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DecoratorResolver.class);
    private final DecoratorService decoratorService;
    private final Map<String, SearchResponseDecorator.Factory> searchResponseDecoratorsMap;

    @Inject
    public DecoratorResolver(DecoratorService decoratorService, Map<String, SearchResponseDecorator.Factory> searchResponseDecorators) {
        this.decoratorService = decoratorService;
        this.searchResponseDecoratorsMap = searchResponseDecorators;
    }

    public List<SearchResponseDecorator> searchResponseDecoratorsForStream(String streamId) {
        return this.decoratorService.findForStream(streamId).stream().sorted().map(this::instantiateSearchResponseDecorator).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<SearchResponseDecorator> searchResponseDecoratorsForGlobal() {
        return this.decoratorService.findForGlobal().stream().sorted().map(this::instantiateSearchResponseDecorator).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private SearchResponseDecorator instantiateSearchResponseDecorator(Decorator decorator) {
        SearchResponseDecorator.Factory factory = this.searchResponseDecoratorsMap.get(decorator.type());
        if (factory != null) {
            try {
                return factory.create(decorator);
            }
            catch (Exception e) {
                LOG.error("Unable to create <{}> decorator", (Object)factory.getDescriptor().getName(), (Object)e);
            }
        }
        return null;
    }
}

