/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;
import org.graylog2.indexer.indexset.CustomFieldMapping;

public class CustomFieldMappings
extends HashSet<CustomFieldMapping> {
    public static final Map<String, TypeDescription> AVAILABLE_TYPES = ImmutableMap.builder().put((Object)"string", (Object)new TypeDescription("String (aggregatable)", FieldTypeMapper.STRING_TYPE)).put((Object)"string_fts", (Object)new TypeDescription("String (full-text searchable)", FieldTypeMapper.STRING_FTS_TYPE)).put((Object)"long", (Object)new TypeDescription("Number", FieldTypeMapper.LONG_TYPE)).put((Object)"double", (Object)new TypeDescription("Number (Floating Point)", FieldTypeMapper.DOUBLE_TYPE)).put((Object)"date", (Object)new TypeDescription("Date", FieldTypeMapper.DATE_TYPE)).put((Object)"boolean", (Object)new TypeDescription("Boolean", FieldTypeMapper.BOOLEAN_TYPE)).put((Object)"binary", (Object)new TypeDescription("Binary Data", FieldTypeMapper.BINARY_TYPE)).put((Object)"geo-point", (Object)new TypeDescription("Geo Point", FieldTypeMapper.GEO_POINT_TYPE)).put((Object)"ip", (Object)new TypeDescription("IP", FieldTypeMapper.IP_TYPE)).build();
    public static final Map<FieldTypes.Type, String> REVERSE_TYPES = AVAILABLE_TYPES.entrySet().stream().collect(Collectors.toMap(entry -> ((TypeDescription)entry.getValue()).type, Map.Entry::getKey));

    public CustomFieldMappings() {
    }

    public CustomFieldMappings(Collection<CustomFieldMapping> mappings) {
        super(mappings);
    }

    public CustomFieldMappings mergeWith(CustomFieldMapping changedMapping) {
        HashSet<CustomFieldMapping> modifiedMappings = new HashSet<CustomFieldMapping>(this);
        modifiedMappings.removeIf(m -> changedMapping.fieldName().equals(m.fieldName()));
        modifiedMappings.add(changedMapping);
        return new CustomFieldMappings((Collection<CustomFieldMapping>)modifiedMappings);
    }

    public record TypeDescription(String description, FieldTypes.Type type) {
    }
}

