/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfigurationFactory;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetConfigFactory.class);
    private final IndexSetsDefaultConfigurationFactory indexSetsDefaultConfigurationFactory;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public IndexSetConfigFactory(IndexSetsDefaultConfigurationFactory indexSetsDefaultConfigurationFactory, ClusterConfigService clusterConfigService) {
        this.indexSetsDefaultConfigurationFactory = indexSetsDefaultConfigurationFactory;
        this.clusterConfigService = clusterConfigService;
    }

    public IndexSetConfig.Builder createDefault() {
        IndexSetsDefaultConfiguration defaultConfig = this.clusterConfigService.get(IndexSetsDefaultConfiguration.class);
        if (defaultConfig == null) {
            LOG.debug("Could not find IndexSetsDefaultConfiguration. Falling back to server configuration values.");
            defaultConfig = this.indexSetsDefaultConfigurationFactory.create();
        }
        return IndexSetConfig.builder().creationDate(IndexSetConfigFactory.getCreationDate()).indexAnalyzer(defaultConfig.indexAnalyzer()).shards(defaultConfig.shards()).replicas(defaultConfig.replicas()).indexOptimizationDisabled(defaultConfig.indexOptimizationDisabled()).indexOptimizationMaxNumSegments(defaultConfig.indexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(Duration.standardSeconds((long)defaultConfig.fieldTypeRefreshIntervalUnit().toSeconds(defaultConfig.fieldTypeRefreshInterval()))).rotationStrategyClass(defaultConfig.rotationStrategyClass()).rotationStrategy(defaultConfig.rotationStrategyConfig()).retentionStrategyClass(defaultConfig.retentionStrategyClass()).retentionStrategy(defaultConfig.retentionStrategyConfig());
    }

    private static ZonedDateTime getCreationDate() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }
}

