/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import io.netty.channel.ChannelFactory;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.graylog2.inputs.transports.netty.NettyTransportType;

public class ServerSocketChannelFactory
implements ChannelFactory<ServerSocketChannel> {
    private final NettyTransportType transportType;

    public ServerSocketChannelFactory(NettyTransportType transportType) {
        this.transportType = transportType;
    }

    public ServerSocketChannel newChannel() {
        switch (this.transportType) {
            case EPOLL: {
                return new EpollServerSocketChannel();
            }
            case KQUEUE: {
                return new KQueueServerSocketChannel();
            }
            case NIO: {
                return new NioServerSocketChannel();
            }
        }
        throw new IllegalArgumentException("Invalid or unknown Netty transport type " + this.transportType);
    }
}

