/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.indexer.datanode.ProxyRequestAdapter;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Api(value="DataNodes/API", description="Proxy direct access to Data Node's API")
@Path(value="/datanodes/request/{path: .*}")
@Produces(value={"application/json"})
@Timed
@RequiresPermissions(value={"*"})
public class DataNodeApiProxyResource
extends RestResource {
    private static final List<Predicate<ProxyRequestAdapter.ProxyRequest>> allowList = List.of(request -> request.path().startsWith("_cat"), request -> request.path().startsWith("_mapping") && request.method().equals("GET"));
    private final ProxyRequestAdapter proxyRequestAdapter;
    private final boolean enableAllowlist;

    @Inject
    public DataNodeApiProxyResource(ProxyRequestAdapter proxyRequestAdapter, @Named(value="datanode_proxy_api_allowlist") boolean enableAllowlist) {
        this.proxyRequestAdapter = proxyRequestAdapter;
        this.enableAllowlist = enableAllowlist;
    }

    @GET
    @ApiOperation(value="GET request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request")
    public Response requestGet(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext.getMethod(), path, requestContext.getEntityStream());
    }

    @POST
    @ApiOperation(value="POST request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request")
    public Response requestPost(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext.getMethod(), path, requestContext.getEntityStream());
    }

    @PUT
    @ApiOperation(value="PUT request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request")
    public Response requestPut(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext.getMethod(), path, requestContext.getEntityStream());
    }

    @DELETE
    @ApiOperation(value="DELETE request to Data Node's API")
    @AuditEvent(type="server:data_node:api_request")
    public Response requestDelete(@ApiParam(name="path", required=true) @PathParam(value="path") String path, @Context ContainerRequestContext requestContext) throws IOException {
        return this.request(requestContext.getMethod(), path, requestContext.getEntityStream());
    }

    private Response request(String method, String path, InputStream entityStream) throws IOException {
        ProxyRequestAdapter.ProxyRequest request = new ProxyRequestAdapter.ProxyRequest(method, path, entityStream);
        if (this.enableAllowlist && allowList.stream().noneMatch(condition -> condition.test(request))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"This request is not allowed.").build();
        }
        ProxyRequestAdapter.ProxyResponse response = this.proxyRequestAdapter.request(request);
        return Response.status((int)response.status()).entity((Object)response.response()).build();
    }
}

