/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.security;

import com.github.joschi.jadconfig.util.Duration;
import com.google.common.base.Suppliers;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.crypto.spec.SecretKeySpec;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class IndexerJwtAuthTokenProvider
implements Provider<String> {
    private final Supplier<String> authHeaderBearerString;
    private static final Logger LOG = LoggerFactory.getLogger(IndexerJwtAuthTokenProvider.class);

    @Inject
    public IndexerJwtAuthTokenProvider(@Named(value="password_secret") String signingKey, @Named(value="indexer_jwt_auth_token_expiration_duration") Duration tokenExpirationDuration, @Named(value="indexer_jwt_auth_token_caching_duration") Duration cachingDuration) {
        this.authHeaderBearerString = Suppliers.memoizeWithExpiration(() -> {
            LOG.debug("Creating new JWT token, expiration set to {}", (Object)tokenExpirationDuration);
            return "Bearer " + IndexerJwtAuthTokenProvider.createToken(signingKey.getBytes(StandardCharsets.UTF_8), tokenExpirationDuration);
        }, (long)cachingDuration.toSeconds(), (TimeUnit)TimeUnit.SECONDS);
    }

    public static String createToken(byte[] apiKeySecretBytes, Duration tokenExpirationDuration) {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        long nowMillis = System.currentTimeMillis();
        Date now = new Date(nowMillis);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        JwtBuilder builder = Jwts.builder().setId("graylog datanode connect " + nowMillis).addClaims(Map.of("os_roles", "admin")).setIssuedAt(now).setSubject("admin").setIssuer("graylog").setNotBefore(now).setExpiration(new Date(nowMillis + tokenExpirationDuration.toMilliseconds())).signWith((Key)signingKey, signatureAlgorithm);
        String token = builder.compact();
        return token;
    }

    public String get() {
        return this.authHeaderBearerString.get();
    }
}

