/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.configuration;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import org.graylog.events.configuration.EventsConfiguration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventsConfigurationProvider
implements Provider<EventsConfiguration> {
    private static final Logger LOG = LoggerFactory.getLogger(EventsConfigurationProvider.class);
    private final ClusterConfigService clusterConfigService;

    @Inject
    public EventsConfigurationProvider(ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
    }

    public EventsConfiguration get() {
        return this.loadFromDatabase().orElse(this.getDefaultConfig());
    }

    public EventsConfiguration getDefaultConfig() {
        return EventsConfiguration.builder().build();
    }

    @NotNull
    public Optional<EventsConfiguration> loadFromDatabase() {
        try {
            return Optional.ofNullable(this.clusterConfigService.get(EventsConfiguration.class));
        }
        catch (Exception e) {
            LOG.error("Failed to fetch events configuration from database", (Throwable)e);
            return Optional.empty();
        }
    }
}

