/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.floreysoft.jmte.Engine;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.graylog.events.notifications.types.EmailEventNotificationConfig;
import org.graylog2.alerts.EmailRecipients;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.alarms.transports.TransportConfigurationException;
import org.graylog2.plugin.system.NodeId;
import org.graylog2.shared.email.EmailFactory;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailSender {
    private static final Logger LOG = LoggerFactory.getLogger(EmailSender.class);
    private final NotificationService notificationService;
    private final NodeId nodeId;
    private final Engine templateEngine;
    private final Engine htmlTemplateEngine;
    private final EmailFactory emailFactory;

    @Inject
    public EmailSender(NotificationService notificationService, NodeId nodeId, Engine templateEngine, @Named(value="HtmlSafe") Engine htmlTemplateEngine, EmailFactory emailFactory) {
        this.notificationService = Objects.requireNonNull(notificationService, "notificationService");
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId");
        this.templateEngine = Objects.requireNonNull(templateEngine, "templateEngine");
        this.htmlTemplateEngine = Objects.requireNonNull(htmlTemplateEngine, "htmlTemplateEngine");
        this.emailFactory = Objects.requireNonNull(emailFactory, "emailFactory");
    }

    @VisibleForTesting
    private String buildSubject(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.subject()) ? "Graylog event notification: ${event_definition_title}" : config.subject();
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    private String buildBody(EmailEventNotificationConfig config, Map<String, Object> model) {
        String template = Strings.isNullOrEmpty((String)config.bodyTemplate()) ? "--- [Event Definition] ---------------------------\nTitle:       ${event_definition_title}\nDescription: ${event_definition_description}\nType:        ${event_definition_type}\n--- [Event] --------------------------------------\nAlert Replay:         ${http_external_uri}alerts/${event.id}/replay-search\nTimestamp:            ${event.timestamp}\nMessage:              ${event.message}\nSource:               ${event.source}\nKey:                  ${event.key}\nPriority:             ${event.priority}\nAlert:                ${event.alert}\nTimestamp Processing: ${event.timestamp}\nTimerange Start:      ${event.timerange_start}\nTimerange End:        ${event.timerange_end}\nSource Streams:       ${event.source_streams}\nFields:\n${foreach event.fields field}  ${field.key}: ${field.value}\n${end}\n${if backlog}\n--- [Backlog] ------------------------------------\nLast messages accounting for this alert:\n${foreach backlog message}\n${message}\n\n${end}\n${end}\n\n" : config.bodyTemplate();
        return this.templateEngine.transform(template, model);
    }

    @VisibleForTesting
    private String buildHtmlBody(EmailEventNotificationConfig config, Map<String, Object> model) {
        return this.htmlTemplateEngine.transform(config.htmlBodyTemplate(), model);
    }

    private void sendEmail(EmailEventNotificationConfig config, String emailAddress, String sender, String replyTo, Map<String, Object> model) throws TransportConfigurationException, EmailException {
        LOG.debug("Sending mail to " + emailAddress);
        if (!this.emailFactory.isEmailTransportEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        Email email = this.createEmailWithBody(config, model);
        if (!Strings.isNullOrEmpty((String)sender)) {
            email.setFrom(sender);
        }
        if (!Strings.isNullOrEmpty((String)replyTo)) {
            email.addReplyTo(replyTo);
        }
        if (email.getFromAddress() == null) {
            throw new TransportConfigurationException("No from address specified for email transport.");
        }
        email.setSubject(this.buildSubject(config, model));
        email.addTo(emailAddress);
        email.send();
    }

    Email createEmailWithBody(EmailEventNotificationConfig config, Map<String, Object> model) throws EmailException {
        if (!Strings.isNullOrEmpty((String)config.htmlBodyTemplate())) {
            HtmlEmail email = this.emailFactory.htmlEmail();
            email.setTextMsg(this.buildBody(config, model));
            email.setHtmlMsg(this.buildHtmlBody(config, model));
            return email;
        }
        SimpleEmail email = this.emailFactory.simpleEmail();
        email.setMsg(this.buildBody(config, model));
        return email;
    }

    void sendEmails(EmailRecipients emailRecipients, String sender, String replyTo, EmailEventNotificationConfig config, String notificationId, Map<String, Object> model) throws TransportConfigurationException, EmailException {
        if (!this.emailFactory.isEmailTransportEnabled()) {
            throw new TransportConfigurationException("Email transport is not enabled in server configuration file!");
        }
        if (emailRecipients.isEmpty()) {
            LOG.debug("Cannot send emails: empty recipient list.");
            return;
        }
        Set<String> recipientsSet = emailRecipients.getEmailRecipients();
        if (recipientsSet.isEmpty()) {
            Notification notification = this.notificationService.buildNow().addNode(this.nodeId.getNodeId()).addType(Notification.Type.GENERIC).addSeverity(Notification.Severity.NORMAL).addDetail("title", StringUtils.f("No recipients have been defined for notification with ID [%s]!", notificationId)).addDetail("description", "To fix this, go to the notification configuration and add at least one alert recipient.");
            this.notificationService.publishIfFirst(notification);
        }
        for (String email : recipientsSet) {
            this.sendEmail(config, email, sender, replyTo, model);
        }
    }
}

