/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AggregationEventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.SeriesSpecEntity;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventDefinitionConfiguration;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.EventProcessorExecutionJob;
import org.graylog.events.processor.EventProcessorSchedulerConfig;
import org.graylog.events.processor.SearchFilterableConfig;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorParameters;
import org.graylog.events.processor.aggregation.AutoValue_AggregationEventProcessorConfig;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.pivot.HasField;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.scheduler.clock.JobSchedulerClock;
import org.graylog.scheduler.schedule.IntervalJobSchedule;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.StreamReferenceFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.rest.ValidationResult;
import org.graylog2.shared.utilities.StringUtils;
import org.joda.time.DateTime;

@JsonTypeName(value="aggregation-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationEventProcessorConfig
implements EventProcessorConfig,
SearchFilterableConfig {
    public static final String TYPE_NAME = "aggregation-v1";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_QUERY_PARAMETERS = "query_parameters";
    private static final String FIELD_FILTERS = "filters";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_GROUP_BY = "group_by";
    static final String FIELD_SERIES = "series";
    private static final String FIELD_CONDITIONS = "conditions";
    private static final String FIELD_SEARCH_WITHIN_MS = "search_within_ms";
    private static final String FIELD_EXECUTE_EVERY_MS = "execute_every_ms";
    private static final String FIELD_EVENT_LIMIT = "event_limit";

    @JsonProperty(value="query")
    public abstract String query();

    @JsonProperty(value="query_parameters")
    public abstract ImmutableSet<Parameter> queryParameters();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty(value="streams")
    public abstract ImmutableSet<String> streams();

    @JsonProperty(value="group_by")
    public abstract List<String> groupBy();

    @JsonProperty(value="series")
    public abstract List<SeriesSpec> series();

    @JsonProperty(value="conditions")
    public abstract Optional<AggregationConditions> conditions();

    @JsonProperty(value="search_within_ms")
    public abstract long searchWithinMs();

    @JsonProperty(value="execute_every_ms")
    public abstract long executeEveryMs();

    @JsonProperty(value="event_limit")
    public abstract int eventLimit();

    @Override
    public Set<String> requiredPermissions() {
        if (this.streams().isEmpty()) {
            return Collections.singleton("streams:read");
        }
        return this.streams().stream().map(streamId -> String.join((CharSequence)":", "streams:read", streamId)).collect(Collectors.toSet());
    }

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public Optional<EventProcessorSchedulerConfig> toJobSchedulerConfig(EventDefinition eventDefinition, JobSchedulerClock clock) {
        DateTime now = clock.nowUTC();
        AbsoluteRange timerange = AbsoluteRange.create(now.minus(this.searchWithinMs()), now);
        EventProcessorExecutionJob.Config jobDefinitionConfig = EventProcessorExecutionJob.Config.builder().eventDefinitionId(eventDefinition.id()).processingWindowSize(this.searchWithinMs()).processingHopSize(this.executeEveryMs()).parameters(((AggregationEventProcessorParameters.Builder)AggregationEventProcessorParameters.builder().timerange(timerange)).build()).build();
        IntervalJobSchedule schedule = IntervalJobSchedule.builder().interval(this.executeEveryMs()).unit(TimeUnit.MILLISECONDS).build();
        return Optional.of(EventProcessorSchedulerConfig.create(jobDefinitionConfig, schedule));
    }

    private boolean isConditionsEmpty() {
        return !this.conditions().isPresent() || !this.conditions().get().expression().isPresent();
    }

    @Override
    public ValidationResult validate() {
        ValidationResult validationResult = new ValidationResult();
        if (this.searchWithinMs() <= 0L) {
            validationResult.addError(FIELD_SEARCH_WITHIN_MS, "Filter & Aggregation search_within_ms must be greater than 0.");
        }
        if (this.executeEveryMs() <= 0L) {
            validationResult.addError(FIELD_EXECUTE_EVERY_MS, "Filter & Aggregation execute_every_ms must be greater than 0.");
        }
        if (!this.groupBy().isEmpty() && (this.series().isEmpty() || this.isConditionsEmpty())) {
            validationResult.addError(FIELD_SERIES, "Aggregation with group_by must also contain series");
            validationResult.addError(FIELD_CONDITIONS, "Aggregation with group_by must also contain conditions");
        }
        if (this.series().isEmpty() && !this.isConditionsEmpty()) {
            validationResult.addError(FIELD_SERIES, "Aggregation with conditions must also contain series");
        }
        if (!this.series().isEmpty() && this.isConditionsEmpty()) {
            validationResult.addError(FIELD_CONDITIONS, "Aggregation with series must also contain conditions");
        }
        this.series().stream().filter(ser -> ser instanceof HasField).forEach(ser -> {
            String field = ((HasField)((Object)ser)).field();
            if (field == null || field.isEmpty()) {
                validationResult.addError(FIELD_SERIES, "Aggregation's series of type " + ser.type() + " must contain non-empty value for field");
            }
        });
        return validationResult;
    }

    @Override
    public ValidationResult validate(@Nullable EventProcessorConfig oldEventProcessorConfig, EventDefinitionConfiguration eventDefinitionConfiguration) {
        ValidationResult validationResult = new ValidationResult();
        if (!this.series().isEmpty()) {
            return validationResult;
        }
        if (oldEventProcessorConfig == null) {
            this.checkEventLimitGreaterZero(validationResult);
        } else if (!(oldEventProcessorConfig instanceof AggregationEventProcessorConfig)) {
            this.checkEventLimitGreaterZero(validationResult);
        } else {
            AggregationEventProcessorConfig oldConfig = (AggregationEventProcessorConfig)oldEventProcessorConfig;
            if (!oldConfig.series().isEmpty()) {
                this.checkEventLimitGreaterZero(validationResult);
            } else if (oldConfig.eventLimit() != 0) {
                this.checkEventLimitGreaterZero(validationResult);
            }
        }
        if (this.eventLimit() > eventDefinitionConfiguration.getMaxEventLimit()) {
            validationResult.addError(FIELD_EVENT_LIMIT, StringUtils.f("Event limit must be less than %s.", eventDefinitionConfiguration.getMaxEventLimit()));
        }
        return validationResult;
    }

    private void checkEventLimitGreaterZero(ValidationResult validationResult) {
        if (this.eventLimit() <= 0) {
            validationResult.addError(FIELD_EVENT_LIMIT, "Event limit must be greater than 0.");
        }
    }

    @Override
    public EventProcessorConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        ImmutableSet streamRefs = ImmutableSet.copyOf((Collection)this.streams().stream().map(streamId -> StreamReferenceFacade.getStreamEntityId(streamId, entityDescriptorIds)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        return ((AggregationEventProcessorConfigEntity.Builder)AggregationEventProcessorConfigEntity.builder().type(this.type())).query(ValueReference.of(this.query())).filters((List<UsedSearchFilter>)ImmutableList.copyOf(this.filters())).streams((ImmutableSet<String>)streamRefs).groupBy(this.groupBy()).series(this.series().stream().map(SeriesSpecEntity::fromNativeEntity).toList()).conditions(this.conditions().orElse(null)).executeEveryMs(this.executeEveryMs()).searchWithinMs(this.searchWithinMs()).eventLimit(this.eventLimit()).build();
    }

    @Override
    public void resolveNativeEntity(EntityDescriptor entityDescriptor, MutableGraph<EntityDescriptor> mutableGraph) {
        this.streams().forEach(streamId -> {
            EntityDescriptor depStream = ((EntityDescriptor.Builder)((EntityDescriptor.Builder)EntityDescriptor.builder().id(ModelId.of(streamId))).type(ModelTypes.STREAM_REF_V1)).build();
            mutableGraph.putEdge((Object)entityDescriptor, (Object)depStream);
        });
    }

    @Override
    public EventProcessorConfig updateFilters(List<UsedSearchFilter> filters) {
        return this.toBuilder().filters(filters).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventProcessorConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return ((Builder)new AutoValue_AggregationEventProcessorConfig.Builder().queryParameters((Set<Parameter>)ImmutableSet.of()).filters(Collections.emptyList()).type(AggregationEventProcessorConfig.TYPE_NAME)).eventLimit(0);
        }

        @JsonProperty(value="query")
        public abstract Builder query(String var1);

        @JsonProperty(value="query_parameters")
        public abstract Builder queryParameters(Set<Parameter> var1);

        @JsonProperty(value="filters")
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(Set<String> var1);

        @JsonProperty(value="group_by")
        public abstract Builder groupBy(List<String> var1);

        @JsonProperty(value="series")
        public abstract Builder series(List<SeriesSpec> var1);

        @JsonProperty(value="conditions")
        public abstract Builder conditions(@Nullable AggregationConditions var1);

        @JsonProperty(value="search_within_ms")
        public abstract Builder searchWithinMs(long var1);

        @JsonProperty(value="execute_every_ms")
        public abstract Builder executeEveryMs(long var1);

        @JsonProperty(value="event_limit")
        public abstract Builder eventLimit(Integer var1);

        public abstract AggregationEventProcessorConfig build();
    }
}

