/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.graylog.events.processor.aggregation.AggregationEventProcessorParameters;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_AggregationEventProcessorParameters
extends AggregationEventProcessorParameters {
    private final String type;
    private final TimeRange timerange;
    private final ImmutableSet<String> streams;
    private final int batchSize;

    private AutoValue_AggregationEventProcessorParameters(String type, TimeRange timerange, ImmutableSet<String> streams, int batchSize) {
        this.type = type;
        this.timerange = timerange;
        this.streams = streams;
        this.batchSize = batchSize;
    }

    @Override
    @JsonProperty(value="type")
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="timerange")
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty(value="streams")
    public ImmutableSet<String> streams() {
        return this.streams;
    }

    @Override
    @JsonProperty(value="batch_size")
    public int batchSize() {
        return this.batchSize;
    }

    public String toString() {
        return "AggregationEventProcessorParameters{type=" + this.type + ", timerange=" + String.valueOf(this.timerange) + ", streams=" + String.valueOf(this.streams) + ", batchSize=" + this.batchSize + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationEventProcessorParameters) {
            AggregationEventProcessorParameters that = (AggregationEventProcessorParameters)o;
            return this.type.equals(that.type()) && this.timerange.equals(that.timerange()) && this.streams.equals(that.streams()) && this.batchSize == that.batchSize();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.type.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.streams.hashCode();
        h$ *= 1000003;
        return h$ ^= this.batchSize;
    }

    @Override
    public AggregationEventProcessorParameters.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationEventProcessorParameters.Builder {
        private String type;
        private TimeRange timerange;
        private ImmutableSet<String> streams;
        private int batchSize;
        private byte set$0;

        Builder() {
        }

        private Builder(AggregationEventProcessorParameters source) {
            this.type = source.type();
            this.timerange = source.timerange();
            this.streams = source.streams();
            this.batchSize = source.batchSize();
            this.set$0 = 1;
        }

        @Override
        public AggregationEventProcessorParameters.Builder type(String type) {
            if (type == null) {
                throw new NullPointerException("Null type");
            }
            this.type = type;
            return this;
        }

        @Override
        public AggregationEventProcessorParameters.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public AggregationEventProcessorParameters.Builder streams(Set<String> streams) {
            this.streams = ImmutableSet.copyOf(streams);
            return this;
        }

        @Override
        public AggregationEventProcessorParameters.Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public AggregationEventProcessorParameters build() {
            if (this.set$0 != 1 || this.type == null || this.timerange == null || this.streams == null) {
                StringBuilder missing = new StringBuilder();
                if (this.type == null) {
                    missing.append(" type");
                }
                if (this.timerange == null) {
                    missing.append(" timerange");
                }
                if (this.streams == null) {
                    missing.append(" streams");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" batchSize");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_AggregationEventProcessorParameters(this.type, this.timerange, this.streams, this.batchSize);
        }
    }
}

