/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog.events.processor.aggregation.AggregationSeriesValue;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;

final class AutoValue_AggregationSeriesValue
extends AggregationSeriesValue {
    private final SeriesSpec series;
    private final ImmutableList<String> key;
    private final double value;

    private AutoValue_AggregationSeriesValue(SeriesSpec series, ImmutableList<String> key, double value) {
        this.series = series;
        this.key = key;
        this.value = value;
    }

    @Override
    public SeriesSpec series() {
        return this.series;
    }

    @Override
    public ImmutableList<String> key() {
        return this.key;
    }

    @Override
    public double value() {
        return this.value;
    }

    public String toString() {
        return "AggregationSeriesValue{series=" + String.valueOf(this.series) + ", key=" + String.valueOf(this.key) + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AggregationSeriesValue) {
            AggregationSeriesValue that = (AggregationSeriesValue)o;
            return this.series.equals(that.series()) && this.key.equals(that.key()) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.value());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.series.hashCode();
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        return h$ ^= (int)(Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value));
    }

    @Override
    public AggregationSeriesValue.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends AggregationSeriesValue.Builder {
        private SeriesSpec series;
        private ImmutableList<String> key;
        private double value;
        private byte set$0;

        Builder() {
        }

        private Builder(AggregationSeriesValue source) {
            this.series = source.series();
            this.key = source.key();
            this.value = source.value();
            this.set$0 = 1;
        }

        @Override
        public AggregationSeriesValue.Builder series(SeriesSpec series) {
            if (series == null) {
                throw new NullPointerException("Null series");
            }
            this.series = series;
            return this;
        }

        @Override
        public AggregationSeriesValue.Builder key(List<String> key) {
            this.key = ImmutableList.copyOf(key);
            return this;
        }

        @Override
        public AggregationSeriesValue.Builder value(double value) {
            this.value = value;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public AggregationSeriesValue build() {
            if (this.set$0 != 1 || this.series == null || this.key == null) {
                StringBuilder missing = new StringBuilder();
                if (this.series == null) {
                    missing.append(" series");
                }
                if (this.key == null) {
                    missing.append(" key");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" value");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_AggregationSeriesValue(this.series, this.key, this.value);
        }
    }
}

