/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.search;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shiro.subject.Subject;
import org.graylog.events.event.EventDto;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.search.EventsSearchParameters;
import org.graylog.events.search.EventsSearchResult;
import org.graylog.events.search.MoreSearch;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.Persisted;
import org.graylog2.streams.StreamService;

public class EventsSearchService {
    private final MoreSearch moreSearch;
    private final StreamService streamService;
    private final DBEventDefinitionService eventDefinitionService;
    private final ObjectMapper objectMapper;

    @Inject
    public EventsSearchService(MoreSearch moreSearch, StreamService streamService, DBEventDefinitionService eventDefinitionService, ObjectMapper objectMapper) {
        this.moreSearch = moreSearch;
        this.streamService = streamService;
        this.eventDefinitionService = eventDefinitionService;
        this.objectMapper = objectMapper;
    }

    private String eventDefinitionFilter(String id) {
        return String.format(Locale.ROOT, "%s:%s", "event_definition_id", id);
    }

    public EventsSearchResult search(EventsSearchParameters parameters, Subject subject) {
        ImmutableSet.Builder filterBuilder = ImmutableSet.builder().add((Object)"_exists_:event_definition_id");
        if (!parameters.filter().eventDefinitions().isEmpty()) {
            String eventDefinitionFilter = parameters.filter().eventDefinitions().stream().map(this::eventDefinitionFilter).collect(Collectors.joining(" OR "));
            filterBuilder.addAll(Collections.singleton("(" + eventDefinitionFilter + ")"));
        }
        switch (parameters.filter().alerts()) {
            case INCLUDE: {
                break;
            }
            case EXCLUDE: {
                filterBuilder.add((Object)"NOT alert:true");
                break;
            }
            case ONLY: {
                filterBuilder.add((Object)"alert:true");
            }
        }
        String filter = String.join((CharSequence)" AND ", (Iterable<? extends CharSequence>)filterBuilder.build());
        ImmutableSet eventStreams = ImmutableSet.of((Object)"000000000000000000000002", (Object)"000000000000000000000003");
        MoreSearch.Result result = this.moreSearch.eventSearch(parameters, filter, (Set<String>)eventStreams, this.forbiddenSourceStreams(subject));
        ImmutableSet.Builder eventDefinitionIdsBuilder = ImmutableSet.builder();
        ImmutableSet.Builder streamIdsBuilder = ImmutableSet.builder();
        List<EventsSearchResult.Event> events = result.results().stream().map(resultMsg -> {
            EventDto eventDto = (EventDto)this.objectMapper.convertValue(resultMsg.getMessage().getFields(), EventDto.class);
            eventDefinitionIdsBuilder.add((Object)((String)resultMsg.getMessage().getField("event_definition_id")));
            streamIdsBuilder.addAll(resultMsg.getMessage().getStreamIds());
            return EventsSearchResult.Event.create(eventDto, resultMsg.getIndex(), "message");
        }).collect(Collectors.toList());
        EventsSearchResult.Context context = EventsSearchResult.Context.create(this.lookupEventDefinitions((Set<String>)eventDefinitionIdsBuilder.build()), this.lookupStreams((Set<String>)streamIdsBuilder.build()));
        return EventsSearchResult.builder().parameters(parameters).totalEvents(result.resultsCount()).duration(result.duration()).events(events).usedIndices(result.usedIndexNames()).context(context).build();
    }

    private Set<String> forbiddenSourceStreams(Subject subject) {
        if (subject.isPermitted("streams:read")) {
            return Collections.emptySet();
        }
        return this.streamService.loadAll().stream().map(Persisted::getId).filter(streamId -> !subject.isPermitted(String.join((CharSequence)":", "streams:read", streamId))).collect(Collectors.toSet());
    }

    private Map<String, EventsSearchResult.ContextEntity> lookupStreams(Set<String> streams) {
        return streams.stream().map(streamId -> {
            try {
                return this.streamService.load((String)streamId);
            }
            catch (NotFoundException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toMap(Persisted::getId, s -> EventsSearchResult.ContextEntity.create(s.getId(), s.getTitle(), s.getDescription())));
    }

    private Map<String, EventsSearchResult.ContextEntity> lookupEventDefinitions(Set<String> eventDefinitions) {
        return eventDefinitions.stream().map(this.eventDefinitionService::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(EventDefinitionDto::id, d -> EventsSearchResult.ContextEntity.create(d.id(), d.title(), d.description(), d.remediationSteps())));
    }
}

