/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.notifications.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.graylog.events.notifications.PermanentEventNotificationException;
import org.graylog.events.notifications.TemporaryEventNotificationException;
import org.graylog.integrations.notifications.types.SlackMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SlackClient {
    private static final Logger LOG = LoggerFactory.getLogger(SlackClient.class);
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    @Inject
    public SlackClient(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = httpClient.newBuilder().followRedirects(false).build();
        this.objectMapper = objectMapper;
    }

    public void send(SlackMessage message, String webhookUrl) throws TemporaryEventNotificationException, PermanentEventNotificationException, JsonProcessingException {
        Request request = new Request.Builder().url(webhookUrl).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString((Object)message))).build();
        LOG.debug("Posting to webhook url <{}> the payload is <{}>", (Object)webhookUrl, (Object)"");
        try (Response r = this.httpClient.newCall(request).execute();){
            if (!r.isSuccessful()) {
                throw new PermanentEventNotificationException("Expected successful HTTP response [2xx] but got [" + r.code() + "]. " + webhookUrl);
            }
        }
        catch (IOException e) {
            throw new TemporaryEventNotificationException("Unable to send the slack Message. " + e.getMessage());
        }
    }
}

