/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.beats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.configuration.Configuration;
import org.graylog2.plugin.configuration.ConfigurationRequest;
import org.graylog2.plugin.configuration.fields.BooleanField;
import org.graylog2.plugin.inputs.annotations.Codec;
import org.graylog2.plugin.inputs.annotations.ConfigClass;
import org.graylog2.plugin.inputs.annotations.FactoryClass;
import org.graylog2.plugin.inputs.codecs.AbstractCodec;
import org.graylog2.plugin.inputs.codecs.Codec;
import org.graylog2.plugin.journal.RawMessage;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Codec(name="beats", displayName="Beats")
public class Beats2Codec
extends AbstractCodec {
    private static final Logger LOG = LoggerFactory.getLogger(Beats2Codec.class);
    private static final String MAP_KEY_SEPARATOR = "_";
    private static final String BEATS_UNKNOWN = "unknown";
    private static final String CK_NO_BEATS_PREFIX = "no_beats_prefix";
    private final ObjectMapper objectMapper;
    private final MessageFactory messageFactory;
    private final boolean noBeatsPrefix;

    @Inject
    public Beats2Codec(@Assisted Configuration configuration, ObjectMapper objectMapper, MessageFactory messageFactory) {
        super(configuration);
        this.noBeatsPrefix = configuration.getBoolean(CK_NO_BEATS_PREFIX, false);
        this.objectMapper = Objects.requireNonNull(objectMapper);
        this.messageFactory = messageFactory;
    }

    @Override
    @Nullable
    public Message decode(@Nonnull RawMessage rawMessage) {
        JsonNode event;
        byte[] payload = rawMessage.getPayload();
        try {
            event = this.objectMapper.readTree(payload);
            if (event == null || event.isMissingNode()) {
                throw new IOException("null result");
            }
        }
        catch (IOException e) {
            LOG.error("Couldn't decode raw message {}", (Object)rawMessage);
            return null;
        }
        return this.parseEvent(event);
    }

    private Message parseEvent(JsonNode event) {
        JsonNode agentName;
        String beatsType = event.path("@metadata").path("beat").asText("beat");
        String rootPath = this.noBeatsPrefix ? "" : beatsType;
        String message = event.path("message").asText("-");
        String timestampField = event.path("@timestamp").asText();
        DateTime timestamp = Tools.dateTimeFromString(timestampField);
        JsonNode agentOrBeat = event.path("agent");
        if (agentOrBeat.isMissingNode()) {
            agentOrBeat = event.path("beat");
        }
        if ((agentName = agentOrBeat.path("hostname")).isMissingNode()) {
            agentName = agentOrBeat.path("name");
        }
        String hostname = agentName.asText(BEATS_UNKNOWN);
        Message gelfMessage = this.messageFactory.createMessage(message, hostname, timestamp);
        gelfMessage.addField("beats_type", beatsType);
        String gl2SourceCollector = event.path("gl2_source_collector").asText();
        if (!gl2SourceCollector.isEmpty()) {
            gelfMessage.addField("gl2_source_collector", gl2SourceCollector);
        }
        if (event.isObject()) {
            ObjectNode onode = (ObjectNode)event;
            onode.remove("message");
            onode.remove("gl2_source_collector");
        }
        this.addFlattened(gelfMessage, rootPath, event);
        return gelfMessage;
    }

    private void addFlattened(Message message, String currentPath, JsonNode jsonNode) {
        if (jsonNode.isObject()) {
            Object pathPrefix;
            Iterator it = jsonNode.fields();
            Object object = pathPrefix = currentPath.isEmpty() ? "" : currentPath + MAP_KEY_SEPARATOR;
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                this.addFlattened(message, (String)pathPrefix + (String)entry.getKey(), (JsonNode)entry.getValue());
            }
        } else if (jsonNode.isArray()) {
            ArrayList<Object> values = new ArrayList<Object>(jsonNode.size());
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode currentNode = jsonNode.get(i);
                if (currentNode.isObject()) {
                    String pathPrefix = currentPath.isEmpty() ? "" : currentPath + MAP_KEY_SEPARATOR + i;
                    this.addFlattened(message, pathPrefix, currentNode);
                    continue;
                }
                if (!currentNode.isValueNode()) continue;
                values.add(this.valueNode(currentNode));
            }
            message.addField(currentPath, values);
        } else if (jsonNode.isValueNode()) {
            message.addField(currentPath, this.valueNode(jsonNode));
        }
    }

    @Nullable
    private Object valueNode(JsonNode jsonNode) {
        if (jsonNode.isInt()) {
            return jsonNode.asInt();
        }
        if (jsonNode.isLong()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isIntegralNumber()) {
            return jsonNode.asLong();
        }
        if (jsonNode.isFloatingPointNumber()) {
            return jsonNode.asDouble();
        }
        if (jsonNode.isBoolean()) {
            return jsonNode.asBoolean();
        }
        if (jsonNode.isNull()) {
            return null;
        }
        return jsonNode.asText();
    }

    public static class Descriptor
    extends AbstractCodec.Descriptor {
        @Inject
        public Descriptor() {
            super(Beats2Codec.class.getAnnotation(Codec.class).displayName());
        }
    }

    @ConfigClass
    public static class Config
    extends AbstractCodec.Config {
        @Override
        public ConfigurationRequest getRequestedConfiguration() {
            ConfigurationRequest configurationRequest = super.getRequestedConfiguration();
            configurationRequest.addField(new BooleanField(Beats2Codec.CK_NO_BEATS_PREFIX, "Do not add Beats type as prefix", false, "Do not prefix each field with the Beats type, e. g. \"source\" -> \"filebeat_source\"."));
            return configurationRequest;
        }
    }

    @FactoryClass
    public static interface Factory
    extends Codec.Factory<Beats2Codec> {
        @Override
        public Beats2Codec create(Configuration var1);

        @Override
        public Config getConfig();

        @Override
        public Descriptor getDescriptor();
    }
}

