/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.config;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.graylog.plugins.map.config.AutoValue_GeoIpResolverConfig;
import org.graylog.plugins.map.config.DatabaseVendorType;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class GeoIpResolverConfig {
    private static final Long DEFAULT_INTERVAL = 10L;
    public static final String FIELD_REFRESH_INTERVAL_UNIT = "refresh_interval_unit";
    public static final String FIELD_REFRESH_INTERVAL = "refresh_interval";
    public static final TimeUnit DEFAULT_INTERVAL_UNIT = TimeUnit.MINUTES;

    @JsonProperty(value="enabled")
    public abstract boolean enabled();

    @JsonProperty(value="enforce_graylog_schema")
    public abstract boolean enforceGraylogSchema();

    @JsonProperty(value="db_vendor_type")
    public abstract DatabaseVendorType databaseVendorType();

    @JsonProperty(value="city_db_path")
    public abstract String cityDbPath();

    @JsonProperty(value="asn_db_path")
    public abstract String asnDbPath();

    @JsonProperty(value="use_s3")
    public abstract boolean useS3();

    @JsonProperty(value="refresh_interval_unit")
    @Nullable
    public abstract TimeUnit refreshIntervalUnit();

    @JsonProperty(value="refresh_interval")
    public abstract Long refreshInterval();

    public Duration refreshIntervalAsDuration() {
        if (this.refreshIntervalUnit() == null) {
            return Duration.ofMinutes(DEFAULT_INTERVAL);
        }
        return Duration.ofMillis(this.refreshIntervalUnit().toMillis(this.refreshInterval()));
    }

    @JsonCreator
    public static GeoIpResolverConfig create(@JsonProperty(value="enabled") boolean cityEnabled, @JsonProperty(value="enforce_graylog_schema") boolean enforceGraylogSchema, @JsonProperty(value="db_vendor_type") DatabaseVendorType databaseVendorType, @JsonProperty(value="city_db_path") String cityDbPath, @JsonProperty(value="asn_db_path") String asnDbPath, @JsonProperty(value="refresh_interval_unit") TimeUnit refreshIntervalUnit, @JsonProperty(value="refresh_interval") Long refreshInterval, @JsonProperty(value="use_s3") boolean useS3) {
        return GeoIpResolverConfig.builder().enabled(cityEnabled).enforceGraylogSchema(enforceGraylogSchema).databaseVendorType(databaseVendorType == null ? DatabaseVendorType.MAXMIND : databaseVendorType).cityDbPath(cityDbPath).asnDbPath(asnDbPath).refreshIntervalUnit(refreshIntervalUnit == null ? DEFAULT_INTERVAL_UNIT : refreshIntervalUnit).refreshInterval(refreshInterval == null ? DEFAULT_INTERVAL : refreshInterval).useS3(useS3).build();
    }

    public static GeoIpResolverConfig defaultConfig() {
        return GeoIpResolverConfig.builder().enabled(false).databaseVendorType(DatabaseVendorType.MAXMIND).enforceGraylogSchema(false).cityDbPath("/etc/graylog/server/GeoLite2-City.mmdb").asnDbPath("/etc/graylog/server/GeoLite2-ASN.mmdb").refreshIntervalUnit(DEFAULT_INTERVAL_UNIT).refreshInterval(DEFAULT_INTERVAL).useS3(false).build();
    }

    public static Builder builder() {
        return new AutoValue_GeoIpResolverConfig.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder enabled(boolean var1);

        public abstract Builder enforceGraylogSchema(boolean var1);

        public abstract Builder databaseVendorType(DatabaseVendorType var1);

        public abstract Builder cityDbPath(String var1);

        public abstract Builder asnDbPath(String var1);

        public abstract Builder refreshIntervalUnit(TimeUnit var1);

        public abstract Builder refreshInterval(Long var1);

        public abstract Builder useS3(boolean var1);

        public abstract GeoIpResolverConfig build();
    }
}

