/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.db.mongodb;

import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import org.bson.conversions.Bson;
import org.graylog.plugins.pipelineprocessor.db.PipelineDao;
import org.graylog.plugins.pipelineprocessor.db.PipelineService;
import org.graylog.plugins.pipelineprocessor.events.PipelinesChangedEvent;
import org.graylog.plugins.pipelineprocessor.processors.PipelineInterpreter;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public class MongoDbPipelineService
implements PipelineService {
    private static final RateLimitedLog log = PipelineInterpreter.getRateLimitedLog(MongoDbPipelineService.class);
    public static final String COLLECTION = "pipeline_processor_pipelines";
    private final JacksonDBCollection<PipelineDao, String> dbCollection;
    private final ClusterEventBus clusterBus;

    @Inject
    public MongoDbPipelineService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, ClusterEventBus clusterBus) {
        this.dbCollection = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION), PipelineDao.class, String.class, mapper.get());
        this.clusterBus = clusterBus;
        this.dbCollection.createIndex((DBObject)DBSort.asc((String)"title"), (DBObject)new BasicDBObject("unique", (Object)true));
    }

    @Override
    public PipelineDao save(PipelineDao pipeline) {
        WriteResult<PipelineDao, String> save = this.dbCollection.save(pipeline);
        PipelineDao savedPipeline = save.getSavedObject();
        this.clusterBus.post(PipelinesChangedEvent.updatedPipelineId(savedPipeline.id()));
        return savedPipeline;
    }

    @Override
    public PipelineDao load(String id) throws NotFoundException {
        PipelineDao pipeline = this.dbCollection.findOneById(id);
        if (pipeline == null) {
            throw new NotFoundException("No pipeline with id " + id);
        }
        return pipeline;
    }

    @Override
    public PipelineDao loadByName(String name) throws NotFoundException {
        DBQuery.Query query = DBQuery.is((String)"title", (Object)name);
        PipelineDao pipeline = this.dbCollection.findOne((Bson)query);
        if (pipeline == null) {
            throw new NotFoundException("No pipeline with name " + name);
        }
        return pipeline;
    }

    @Override
    public Collection<PipelineDao> loadAll() {
        DBCursor<PipelineDao> daos = this.dbCollection.find();
        try {
            ImmutableSet immutableSet = ImmutableSet.copyOf(daos);
            if (daos != null) {
                daos.close();
            }
            return immutableSet;
        }
        catch (Throwable throwable) {
            try {
                if (daos != null) {
                    try {
                        daos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (MongoException e) {
                log.error("Unable to load pipelines", (Throwable)e);
                return Collections.emptySet();
            }
        }
    }

    @Override
    public void delete(String id) {
        this.dbCollection.removeById(id);
        this.clusterBus.post(PipelinesChangedEvent.deletedPipelineId(id));
    }

    @Override
    public long count(DBQuery.Query query) {
        return this.dbCollection.getCount((Bson)query);
    }
}

