/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.arrays;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.arrays.AbstractArrayFunction;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class ArrayContains
extends AbstractArrayFunction<Boolean> {
    public static final String NAME = "array_contains";
    private final ParameterDescriptor<Object, List> elementsParam;
    private final ParameterDescriptor<Object, Object> valueParam;
    private final ParameterDescriptor<Boolean, Boolean> caseSensitiveParam;
    private final ObjectMapper objectMapper;

    @Inject
    public ArrayContains(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.elementsParam = ParameterDescriptor.type("elements", Object.class, List.class).transform(AbstractArrayFunction::toList).description("The input array, may be null").build();
        this.valueParam = ParameterDescriptor.object("value").description("The input value").build();
        this.caseSensitiveParam = ParameterDescriptor.bool("case_sensitive").optional().description("Whether or not to ignore case when checking string arrays").build();
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        List<Object> elements = this.elementsParam.optional(args, context).orElse(Collections.emptyList());
        Object value = this.valueParam.required(args, context);
        boolean caseSensitive = this.caseSensitiveParam.optional(args, context).orElse(false);
        if (elements.isEmpty()) {
            return false;
        }
        if (!caseSensitive && ArrayContains.containsStringValue(elements)) {
            return elements.stream().anyMatch(e -> e.toString().equalsIgnoreCase(String.valueOf(value)));
        }
        return this.arrayContains(elements, value);
    }

    private boolean arrayContains(List<Object> elements, Object value) {
        for (Object element : elements.stream().filter(e -> !(e instanceof NullNode)).toList()) {
            if (element instanceof IntNode || element instanceof LongNode) {
                Number number = ((NumericNode)element).numberValue();
                if (value.equals(number.intValue())) {
                    return true;
                }
                if (!value.equals(number.longValue())) continue;
                return true;
            }
            if (!(element instanceof JsonNode) || !this.objectMapper.convertValue(element, Object.class).equals(value)) continue;
            return true;
        }
        return elements.contains(value);
    }

    private static boolean containsStringValue(List elements) {
        return elements.get(0) instanceof String;
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(Boolean.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.elementsParam, this.valueParam, this.caseSensitiveParam)).description("Checks if the specified element is contained in the array.").ruleBuilderEnabled().ruleBuilderName("Check if array contains value").ruleBuilderTitle("Check if '${value}' is contained in array '${elements}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.ARRAY).build();
    }
}

