/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.conversion;

import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class IsDouble
extends AbstractFunction<Boolean> {
    public static final String NAME = "is_double";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").ruleBuilderVariable().description("Value to check").build();
    private final ParameterDescriptor<Boolean, Boolean> conversionParam = ParameterDescriptor.bool("attemptConversion").optional().description("Try to convert value to double from its string representation").build();

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        Object value = this.valueParam.required(args, context);
        boolean convert = this.conversionParam.optional(args, context).orElse(false);
        if (!convert) {
            return value instanceof Double;
        }
        if (value instanceof Double) {
            return true;
        }
        try {
            Double.parseDouble(String.valueOf(value));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public FunctionDescriptor<Boolean> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Boolean.class).params(this.valueParam, this.conversionParam).description("Checks whether a value is a floating point value (of type double)").ruleBuilderEnabled(false).ruleBuilderName("Check if double").ruleBuilderTitle("Check if '${value}' is a double").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.BOOLEAN).build();
    }
}

