/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.messages;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.MessageFactory;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;

public class CreateMessage
extends AbstractFunction<Message> {
    public static final String NAME = "create_message";
    private static final String MESSAGE_ARG = "message";
    private static final String SOURCE_ARG = "source";
    private static final String TIMESTAMP_ARG = "timestamp";
    private final ParameterDescriptor<String, String> messageParam;
    private final ParameterDescriptor<String, String> sourceParam;
    private final ParameterDescriptor<DateTime, DateTime> timestampParam;
    private final MessageFactory messageFactory;

    @Inject
    public CreateMessage(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
        this.messageParam = ParameterDescriptor.string(MESSAGE_ARG).optional().description("The 'message' field of the new message, defaults to '$message.message'").build();
        this.sourceParam = ParameterDescriptor.string(SOURCE_ARG).optional().description("The 'source' field of the new message, defaults to '$message.source'").build();
        this.timestampParam = ParameterDescriptor.type(TIMESTAMP_ARG, DateTime.class).optional().description("The 'timestamp' field of the message, defaults to 'now'").build();
    }

    @Override
    public Message evaluate(FunctionArgs args, EvaluationContext context) {
        Optional<String> optMessage = this.messageParam.optional(args, context);
        String message = optMessage.isPresent() ? optMessage.get() : context.currentMessage().getMessage();
        Optional<String> optSource = this.sourceParam.optional(args, context);
        String source = optSource.isPresent() ? optSource.get() : context.currentMessage().getSource();
        Optional<DateTime> optTimestamp = this.timestampParam.optional(args, context);
        DateTime timestamp = optTimestamp.isPresent() ? optTimestamp.get() : Tools.nowUTC();
        Message newMessage = this.messageFactory.createMessage(message, source, timestamp);
        context.addCreatedMessage(newMessage);
        return newMessage;
    }

    @Override
    public FunctionDescriptor<Message> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(Message.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.messageParam, this.sourceParam, this.timestampParam)).description("Creates a new message which will be evaluated by the entire processing pipeline. Any omitted parameters (message, source, timestamp) will inherit their values from the currently processed message. The timestamp will inherit the current timestamp.").ruleBuilderEnabled().ruleBuilderName("Create message").ruleBuilderTitle("Create a new message").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.MESSAGE).build();
    }
}

