/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class RegexMatch
extends AbstractFunction<RegexMatchResult> {
    public static final String NAME = "regex";
    private final ParameterDescriptor<String, Pattern> pattern = ParameterDescriptor.string("pattern", Pattern.class).transform(Pattern::compile).description("The regular expression to match against 'value', uses Java regex syntax").build();
    private final ParameterDescriptor<String, String> value = ParameterDescriptor.string("value").description("The string to match the pattern against").build();
    private final ParameterDescriptor<List, List> optionalGroupNames = ParameterDescriptor.type("group_names", List.class).optional().description("List of names to use for matcher groups").build();

    @Override
    public RegexMatchResult evaluate(FunctionArgs args, EvaluationContext context) {
        Pattern regex = this.pattern.required(args, context);
        String value = this.value.required(args, context);
        if (regex == null || value == null) {
            String nullArgument = regex == null ? "pattern" : "value";
            throw new IllegalArgumentException(context.pipelineErrorMessage("Argument '" + nullArgument + "' cannot be 'null'"));
        }
        List<String> groupNames = this.optionalGroupNames.optional(args, context).orElse(Collections.emptyList());
        Matcher matcher = regex.matcher(value);
        boolean matches = matcher.find();
        return new RegexMatchResult(matches, matcher.toMatchResult(), groupNames);
    }

    @Override
    public FunctionDescriptor<RegexMatchResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(RegexMatchResult.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.pattern, this.value, this.optionalGroupNames)).description("Match a string with a regular expression (Java syntax)").build();
    }

    public static class RegexMatchResult
    extends ForwardingMap<String, String> {
        private final boolean matches;
        private final ImmutableMap<String, String> groups;

        public RegexMatchResult(boolean matches, MatchResult matchResult, List<String> groupNames) {
            this.matches = matches;
            ImmutableMap.Builder builder = ImmutableMap.builder();
            if (matches) {
                int groupCount = matchResult.groupCount();
                for (int i = 1; i <= groupCount; ++i) {
                    String groupValue = matchResult.group(i);
                    if (groupValue == null) continue;
                    String groupName = (String)Iterables.get(groupNames, (int)(i - 1), null);
                    builder.put((Object)(groupName != null ? groupName : String.valueOf(i - 1)), (Object)groupValue);
                }
            }
            this.groups = builder.build();
        }

        public boolean isMatches() {
            return this.matches;
        }

        public Map<String, String> getGroups() {
            return this.groups;
        }

        protected Map<String, String> delegate() {
            return this.getGroups();
        }
    }
}

