/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class Split
extends AbstractFunction<List<String>> {
    private static final Class<List<String>> RETURN_TYPE = new TypeToken<List<String>>(){}.getRawType();
    public static final String NAME = "split";
    private final ParameterDescriptor<String, Pattern> pattern = ParameterDescriptor.string("pattern", Pattern.class).transform(Pattern::compile).description("The regular expression to split by, uses Java regex syntax").build();
    private final ParameterDescriptor<String, String> value = ParameterDescriptor.string("value").ruleBuilderVariable().description("The string to be split").build();
    private final ParameterDescriptor<Long, Integer> limit = ParameterDescriptor.integer("limit", Integer.class).transform(Ints::saturatedCast).description("The number of times the pattern is applied").optional().build();

    @Override
    public List<String> evaluate(FunctionArgs args, EvaluationContext context) {
        Pattern regex = Objects.requireNonNull(this.pattern.required(args, context), "Argument 'pattern' cannot be 'null'");
        String value = Objects.requireNonNull(this.value.required(args, context), "Argument 'value' cannot be 'null'");
        int limit = this.limit.optional(args, context).orElse(0);
        Preconditions.checkArgument((limit >= 0 ? 1 : 0) != 0, (Object)"Argument 'limit' cannot be negative");
        return ImmutableList.copyOf((Object[])regex.split(value, limit));
    }

    @Override
    public FunctionDescriptor<List<String>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(RETURN_TYPE).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.pattern, this.value, this.limit)).description("Split a string around matches of this pattern (Java syntax)").ruleBuilderEnabled().ruleBuilderName("Split string").ruleBuilderTitle("Split '${value}' around matches of pattern '${pattern}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.STRING).build();
    }
}

