/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.syslog;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogUtils;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;

public class SyslogFacilityConversion
extends AbstractFunction<String> {
    public static final String NAME = "syslog_facility";
    private final ParameterDescriptor<Object, Object> valueParam = ParameterDescriptor.object("value").description("Value to convert").build();

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        String s = String.valueOf(this.valueParam.required(args, context));
        Integer facility = (Integer)MoreObjects.firstNonNull((Object)Ints.tryParse((String)s), (Object)-1);
        return SyslogUtils.facilityToString(facility);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(String.class).params(this.valueParam).description("Converts a syslog facility number to its string representation").ruleBuilderEnabled().ruleBuilderName("Convert syslog facility").ruleBuilderTitle("Converts a syslog facility number in '${value}' to string").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.SYSLOG).build();
    }
}

