/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.db;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import javax.annotation.Nullable;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.AutoValue_RuleFragment;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@JsonIgnoreProperties(value={"name"}, allowGetters=true)
@AutoValue
public abstract class RuleFragment {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_FRAGMENT = "fragment";
    public static final String FIELD_FRAGMENT_OUTPUT = "fragment_output_variable";
    public static final String FIELD_CONDITION = "isCondition";
    public static final String FIELD_DESCRIPTOR = "descriptor";

    @JsonIgnore
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="name")
    public String getName() {
        return this.descriptor().name();
    }

    @JsonProperty(value="fragment")
    @Nullable
    public abstract String fragment();

    @JsonProperty(value="fragment_output_variable")
    @Nullable
    public abstract String fragmentOutputVariable();

    @JsonProperty(value="isCondition")
    public abstract boolean isCondition();

    @JsonProperty(value="descriptor")
    public abstract FunctionDescriptor descriptor();

    public static Builder builder() {
        return new AutoValue_RuleFragment.Builder().isCondition(false);
    }

    @JsonIgnore
    public boolean isFragment() {
        return Objects.nonNull(this.fragment());
    }

    @JsonIgnore
    public boolean isFunction() {
        return Objects.isNull(this.fragment());
    }

    @JsonCreator
    public static RuleFragment create(@Id @ObjectId @JsonProperty(value="_id") @Nullable String id, @JsonProperty(value="fragment") String fragment, @JsonProperty(value="fragment_output_variable") @Nullable String fragmentOutputVariable, @JsonProperty(value="isCondition") boolean isCondition, @JsonProperty(value="descriptor") FunctionDescriptor descriptor) {
        return RuleFragment.builder().id(id).fragment(fragment).fragmentOutputVariable(fragmentOutputVariable).isCondition(isCondition).descriptor(descriptor).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder id(String var1);

        public abstract Builder descriptor(FunctionDescriptor var1);

        public abstract Builder fragment(String var1);

        public abstract Builder isCondition(boolean var1);

        public Builder isCondition() {
            return this.isCondition(true);
        }

        public abstract Builder fragmentOutputVariable(String var1);

        public abstract RuleFragment build();
    }
}

