/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.rulebuilder.parser;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderStep;
import org.graylog.plugins.pipelineprocessor.rulebuilder.db.RuleFragment;
import org.graylog.plugins.pipelineprocessor.rulebuilder.parser.ConditionParser;
import org.graylog2.bindings.providers.SecureFreemarkerConfigProvider;
import org.graylog2.shared.utilities.StringUtils;

public class ParserUtil {
    static final String generateForFunction(RuleBuilderStep step, FunctionDescriptor<?> function) {
        return ParserUtil.generateForFunction(step, function, 1);
    }

    static final String generateForFunction(RuleBuilderStep step, FunctionDescriptor<?> function, int level) {
        String syntax = function.name() + "(";
        String params = function.params().stream().map(p -> ParserUtil.addFunctionParameter(p, step)).filter(Objects::nonNull).collect(Collectors.joining("," + ConditionParser.NL));
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)params)) {
            return syntax + ")";
        }
        return syntax + ConditionParser.NL + params + ConditionParser.NL + org.apache.commons.lang3.StringUtils.repeat((String)"  ", (int)level) + ")";
    }

    static final String addFunctionParameter(ParameterDescriptor descriptor, RuleBuilderStep step) {
        String parameterName = descriptor.name();
        Map<String, Object> parameters = step.parameters();
        if (Objects.isNull(parameters)) {
            return null;
        }
        Object value = parameters.get(parameterName);
        String syntax = "    " + parameterName + " : ";
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String valueString = (String)value;
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)valueString)) {
                return null;
            }
            syntax = valueString.startsWith("$") ? syntax + valueString.substring(1) : syntax + "\"" + StringEscapeUtils.escapeJava((String)valueString) + "\"";
        } else {
            syntax = syntax + String.valueOf(value);
        }
        return syntax;
    }

    static final Configuration initializeFragmentTemplates(SecureFreemarkerConfigProvider secureFreemarkerConfigProvider, Map<String, RuleFragment> fragments) {
        Configuration freemarkerConfiguration = secureFreemarkerConfigProvider.get();
        StringTemplateLoader stringTemplateLoader = new StringTemplateLoader();
        fragments.entrySet().stream().filter(c -> ((RuleFragment)c.getValue()).isFragment()).forEach(c -> stringTemplateLoader.putTemplate((String)c.getKey(), ((RuleFragment)c.getValue()).fragment()));
        freemarkerConfiguration.setTemplateLoader((TemplateLoader)stringTemplateLoader);
        return freemarkerConfiguration;
    }

    static final String generateForFragment(RuleBuilderStep step, Configuration configuration) {
        String fragmentName = step.function();
        try {
            Template template = configuration.getTemplate(fragmentName);
            StringWriter writer = new StringWriter();
            HashMap<String, Object> filteredParams = new HashMap<String, Object>();
            if (step.parameters() != null) {
                for (Map.Entry<String, Object> val : step.parameters().entrySet()) {
                    Object object = val.getValue();
                    if (object instanceof String) {
                        String s = (String)object;
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)s)) continue;
                        if (s.startsWith("$")) {
                            filteredParams.put(val.getKey(), s.substring(1));
                            continue;
                        }
                        filteredParams.put(val.getKey(), "\"" + s + "\"");
                        continue;
                    }
                    filteredParams.put(val.getKey(), val.getValue());
                }
            }
            template.process(filteredParams, (Writer)writer);
            writer.close();
            return writer.toString();
        }
        catch (TemplateNotFoundException e) {
            throw new IllegalArgumentException(StringUtils.f("No template found for fragment %s", fragmentName));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error converting fragment template to fragment.", e);
        }
    }
}

