/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.simulator;

import java.util.Set;
import org.graylog.plugins.pipelineprocessor.ast.Pipeline;
import org.graylog.plugins.pipelineprocessor.ast.Rule;
import org.graylog.plugins.pipelineprocessor.ast.Stage;
import org.graylog.plugins.pipelineprocessor.processors.listeners.InterpreterListener;
import org.graylog.plugins.pipelineprocessor.simulator.PipelineInterpreterTracer;
import org.graylog2.plugin.Message;

class SimulatorInterpreterListener
implements InterpreterListener {
    private final PipelineInterpreterTracer executionTrace;

    SimulatorInterpreterListener(PipelineInterpreterTracer executionTrace) {
        this.executionTrace = executionTrace;
    }

    @Override
    public void startProcessing() {
        this.executionTrace.startProcessing("Starting message processing");
    }

    @Override
    public void finishProcessing() {
        this.executionTrace.finishProcessing("Finished message processing");
    }

    @Override
    public void processStreams(Message message, Set<Pipeline> pipelines, Set<String> streams) {
        this.executionTrace.addTrace("Message " + message.getId() + " running " + String.valueOf(pipelines) + " for streams " + String.valueOf(streams));
    }

    @Override
    public void enterStage(Stage stage) {
        this.executionTrace.addTrace("Enter " + String.valueOf(stage));
    }

    @Override
    public void exitStage(Stage stage) {
        this.executionTrace.addTrace("Exit " + String.valueOf(stage));
    }

    @Override
    public void evaluateRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Evaluate " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void failEvaluateRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Failed evaluation " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void satisfyRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Evaluation satisfied " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void dissatisfyRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Evaluation not satisfied " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void executeRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Execute " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void finishExecuteRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Finished execution " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void failExecuteRule(Rule rule, Pipeline pipeline) {
        this.executionTrace.addTrace("Failed execution " + String.valueOf(rule) + " in " + String.valueOf(pipeline));
    }

    @Override
    public void continuePipelineExecution(Pipeline pipeline, Stage stage) {
        this.executionTrace.addTrace("Completed " + String.valueOf(stage) + " for " + String.valueOf(pipeline) + ", continuing to next stage");
    }

    @Override
    public void stopPipelineExecution(Pipeline pipeline, Stage stage) {
        this.executionTrace.addTrace("Completed " + String.valueOf(stage) + " for " + String.valueOf(pipeline) + ", NOT continuing to next stage");
    }
}

