/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import com.mongodb.BasicDBObject;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.sidecar.rest.models.CollectorAction;
import org.graylog.plugins.sidecar.rest.models.CollectorActions;
import org.graylog.plugins.sidecar.services.EtagService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.mongojack.DBQuery;
import org.mongojack.JacksonDBCollection;

public class ActionService {
    private static final String COLLECTION_NAME = "sidecar_collector_actions";
    private final JacksonDBCollection<CollectorActions, ObjectId> dbCollection;
    private final EtagService etagService;

    @Inject
    public ActionService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EtagService etagService) {
        this.etagService = etagService;
        this.dbCollection = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(COLLECTION_NAME), CollectorActions.class, ObjectId.class, mapper.get());
    }

    public CollectorActions fromRequest(String sidecarId, List<CollectorAction> actions) {
        CollectorActions collectorActions = this.findActionBySidecar(sidecarId, false);
        if (collectorActions == null) {
            return CollectorActions.create(sidecarId, DateTime.now((DateTimeZone)DateTimeZone.UTC), actions);
        }
        ArrayList<CollectorAction> updatedActions = new ArrayList<CollectorAction>();
        for (CollectorAction action : actions) {
            for (CollectorAction existingsAction : collectorActions.action()) {
                if (existingsAction.collectorId().equals(action.collectorId())) continue;
                updatedActions.add(existingsAction);
            }
            updatedActions.add(action);
        }
        return CollectorActions.create(collectorActions.id(), sidecarId, DateTime.now((DateTimeZone)DateTimeZone.UTC), updatedActions);
    }

    public CollectorActions saveAction(CollectorActions collectorActions) {
        CollectorActions actions = this.dbCollection.findAndModify((Bson)DBQuery.is((String)"sidecar_id", (Object)collectorActions.sidecarId()), (Bson)new BasicDBObject(), (Bson)new BasicDBObject(), false, collectorActions, true, true);
        this.etagService.invalidateRegistration(collectorActions.sidecarId());
        return actions;
    }

    public CollectorActions findActionBySidecar(String sidecarId, boolean remove) {
        if (remove) {
            return this.dbCollection.findAndRemove((Bson)DBQuery.is((String)"sidecar_id", (Object)sidecarId));
        }
        return this.dbCollection.findOne((Bson)DBQuery.is((String)"sidecar_id", (Object)sidecarId));
    }
}

