/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.whois.ip;

import jakarta.inject.Inject;
import java.util.Map;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.threatintel.functions.misc.LookupTableFunction;
import org.graylog.plugins.threatintel.whois.ip.WhoisIpLookupResult;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WhoisLookupIpFunction
extends LookupTableFunction<WhoisIpLookupResult> {
    private static final Logger LOG = LoggerFactory.getLogger(WhoisLookupIpFunction.class);
    public static final String NAME = "whois_lookup_ip";
    private static final String VALUE = "ip_address";
    private static final String PREFIX = "prefix";
    private static final String LOOKUP_TABLE_NAME = "whois";
    private final ParameterDescriptor<String, String> valueParam = ParameterDescriptor.string("ip_address").description("The IPv4 or IPv6 address to look up.").build();
    private final ParameterDescriptor<String, String> prefixParam = ParameterDescriptor.string("prefix").description("A prefix for results. For example \"src_addr\" will result in fields called \"src_addr_whois_org\".").build();
    private final LookupTableService.Function lookupFunction;

    @Inject
    public WhoisLookupIpFunction(LookupTableService lookupTableService) {
        this.lookupFunction = lookupTableService.newBuilder().lookupTable(LOOKUP_TABLE_NAME).build();
    }

    @Override
    public WhoisIpLookupResult evaluate(FunctionArgs args, EvaluationContext context) {
        String ip = this.valueParam.required(args, context);
        String prefix = this.prefixParam.required(args, context);
        if (ip == null) {
            LOG.error("NULL parameter passed to WHOIS IP lookup.");
            return null;
        }
        if (prefix == null) {
            LOG.error("NULL prefix parameter passed to global IP lookup.");
            return null;
        }
        LOG.debug("Running WHOIS lookup for IP [{}] with prefix [{}].", (Object)ip, (Object)prefix);
        LookupResult lookupResult = this.lookupFunction.lookup(ip);
        if (lookupResult == null || lookupResult.isEmpty()) {
            return null;
        }
        Map<Object, Object> fields = lookupResult.multiValue();
        WhoisIpLookupResult result = new WhoisIpLookupResult(String.valueOf(fields.get("organization")), String.valueOf(fields.get("country_code")));
        result.setPrefix(prefix.trim());
        return result;
    }

    @Override
    public FunctionDescriptor<WhoisIpLookupResult> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Get WHOIS information of an IP address").params(this.valueParam, this.prefixParam).returnType(WhoisIpLookupResult.class).build();
    }
}

