/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.BackendQuery;
import org.graylog.plugins.views.migrations.V20200204122000_MigrateUntypedViewsToDashboards.Query;

class Widget {
    private static final String FIELD_FILTER = "filter";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_QUERY_STRING = "query_string";
    private static final String FIELD_TIMERANGE = "timerange";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_ID = "id";
    private final Document widgetDocument;

    Widget(Document widgetDocument) {
        this.widgetDocument = widgetDocument;
    }

    void mergeFilterIntoQueryIfPresent() {
        this.filter().ifPresent(filter -> {
            this.widgetDocument.remove((Object)FIELD_FILTER);
            this.mergeQueryString((String)filter);
        });
    }

    void mergeQuerySpecsIntoWidget(Query query) {
        query.queryString().filter(queryString -> !queryString.trim().isEmpty()).ifPresent(this::mergeQueryString);
        if (!this.timerange().isPresent()) {
            query.timeRange().ifPresent(this::setTimerange);
        }
        Sets.SetView newStreams = Sets.union(query.streams(), this.streams());
        this.setStreams((Set<String>)newStreams);
    }

    private void mergeQueryString(String queryString) {
        String newWidgetQuery = this.concatenateQueryIfExists(queryString);
        this.setQueryString(newWidgetQuery);
    }

    private void setQueryString(String newWidgetQuery) {
        this.widgetDocument.put(FIELD_QUERY, (Object)this.createBackendQuery(newWidgetQuery));
    }

    Optional<Document> query() {
        return Optional.ofNullable((Document)this.widgetDocument.get((Object)FIELD_QUERY, Document.class));
    }

    private void setTimerange(Document timerange) {
        this.widgetDocument.put(FIELD_TIMERANGE, (Object)timerange);
    }

    private void setStreams(Set<String> streams) {
        this.widgetDocument.put(FIELD_STREAMS, streams);
    }

    private Optional<String> filter() {
        return Optional.ofNullable(this.widgetDocument.getString((Object)FIELD_FILTER));
    }

    Optional<Document> timerange() {
        return Optional.ofNullable((Document)this.widgetDocument.get((Object)FIELD_TIMERANGE, Document.class));
    }

    Set<String> streams() {
        Collection streams = (Collection)this.widgetDocument.get((Object)FIELD_STREAMS, Collection.class);
        return streams == null ? Collections.emptySet() : new HashSet(streams);
    }

    private String concatenateQueries(String query1, String query2) {
        return query1 + " AND " + query2;
    }

    private String concatenateQueryIfExists(String newQuery) {
        Optional<String> currentWidgetQuery = this.extractWidgetQuery(this.widgetDocument);
        return currentWidgetQuery.map(widgetQuery -> this.concatenateQueries((String)widgetQuery, newQuery)).orElse(newQuery);
    }

    private Optional<String> extractWidgetQuery(Document widget) {
        if (!widget.containsKey((Object)FIELD_QUERY)) {
            return Optional.empty();
        }
        Document query = (Document)widget.get((Object)FIELD_QUERY);
        if (!query.containsKey((Object)FIELD_QUERY_STRING) || !(query.get((Object)FIELD_QUERY_STRING) instanceof String)) {
            return Optional.empty();
        }
        return Optional.ofNullable(query.getString((Object)FIELD_QUERY_STRING));
    }

    private Document createBackendQuery(String filter) {
        return new BackendQuery(filter);
    }

    String id() {
        return this.widgetDocument.getString((Object)FIELD_ID);
    }
}

