/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.engine.monitoring.data.histogram.creation.BinChooser;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class PeriodBasedBinChooser
implements BinChooser<Period, QueryExecutionStats> {
    @Override
    public Optional<Period> chooseBin(List<Period> availablePeriods, QueryExecutionStats stats) {
        return availablePeriods.stream().filter(per -> this.matches((Period)per, stats.effectiveTimeRange())).findFirst();
    }

    private boolean matches(Period binRange, TimeRange statsRange) {
        Duration statsRangeAsDuration = new Duration((ReadableInstant)statsRange.getFrom().toInstant(), (ReadableInstant)statsRange.getTo().toInstant());
        return binRange.toStandardDuration().compareTo((ReadableDuration)statsRangeAsDuration) >= 0;
    }

    @Override
    public Optional<Comparator<Period>> getBinComparator() {
        return Optional.of(Comparator.comparing(Period::toStandardDuration));
    }
}

