/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.engine.normalization;

import jakarta.inject.Inject;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.ParameterProvider;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.ElasticsearchQueryString;
import org.graylog.plugins.views.search.elasticsearch.QueryStringDecorators;
import org.graylog.plugins.views.search.engine.normalization.SearchNormalizer;
import org.graylog.plugins.views.search.filter.QueryStringFilter;

public class DecorateQueryStringsNormalizer
implements SearchNormalizer {
    private final QueryStringDecorators queryStringDecorators;

    @Inject
    public DecorateQueryStringsNormalizer(QueryStringDecorators queryStringDecorators) {
        this.queryStringDecorators = queryStringDecorators;
    }

    @Override
    public Query normalizeQuery(Query query, ParameterProvider parameterProvider) {
        return query.toBuilder().query(ElasticsearchQueryString.of(this.queryStringDecorators.decorate(query.query().queryString(), parameterProvider, query))).filter(this.normalizeFilter(query.filter(), query, parameterProvider)).searchTypes(query.searchTypes().stream().map(searchType -> this.normalizeSearchType((SearchType)searchType, query, parameterProvider)).collect(Collectors.toSet())).build();
    }

    private Filter normalizeFilter(Filter filter, Query query, ParameterProvider parameterProvider) {
        if (filter == null) {
            return filter;
        }
        Filter normalizedFilter = filter;
        if (filter instanceof QueryStringFilter) {
            QueryStringFilter queryStringFilter = (QueryStringFilter)filter;
            normalizedFilter = queryStringFilter.withQuery(this.queryStringDecorators.decorate(queryStringFilter.query(), parameterProvider, query));
        }
        if (normalizedFilter.filters() == null) {
            return normalizedFilter;
        }
        return normalizedFilter.withFilters(normalizedFilter.filters().stream().map(f -> this.normalizeFilter((Filter)f, query, parameterProvider)).collect(Collectors.toSet()));
    }

    private SearchType normalizeSearchType(SearchType searchType, Query query, ParameterProvider parameterProvider) {
        SearchType searchTypeWithNormalizedQuery = searchType.query().map(backendQuery -> searchType.withQuery(ElasticsearchQueryString.of(this.queryStringDecorators.decorate(backendQuery.queryString(), parameterProvider, query)))).orElse(searchType);
        return searchTypeWithNormalizedQuery.withFilter(this.normalizeFilter(searchType.filter(), query, parameterProvider));
    }
}

