/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.graylog.plugins.views.search.events.AutoValue_MessagesExportEvent;
import org.graylog.plugins.views.search.export.AuditContext;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.joda.time.DateTime;

@JsonAutoDetect
@AutoValue
public abstract class MessagesExportEvent {
    public static MessagesExportEvent requested(DateTime startTime, AuditContext context, ExportMessagesCommand command) {
        return MessagesExportEvent.from(startTime, context, command, "views:messages:export_requested");
    }

    public static MessagesExportEvent succeeded(DateTime startTime, AuditContext context, ExportMessagesCommand command) {
        return MessagesExportEvent.from(startTime, context, command, "views:messages:export_succeeded");
    }

    private static MessagesExportEvent from(DateTime startTime, AuditContext context, ExportMessagesCommand command, String auditType) {
        Builder builder = Builder.create().userName(context.userName()).auditType(auditType).timestamp(startTime).timeRange(command.timeRange()).queryString(command.queryString().queryString()).streams(command.streams()).fieldsInOrder(command.fieldsInOrder());
        if (command.limit().isPresent()) {
            builder.limit(command.limit().getAsInt());
        }
        if (context.searchId().isPresent()) {
            builder.searchId(context.searchId().get());
        }
        if (context.searchTypeId().isPresent()) {
            builder.searchTypeId(context.searchTypeId().get());
        }
        return builder.build();
    }

    public abstract String userName();

    public abstract String auditType();

    public abstract DateTime timestamp();

    public abstract AbsoluteRange timeRange();

    public abstract String queryString();

    public abstract Set<String> streams();

    public abstract LinkedHashSet<String> fieldsInOrder();

    public abstract OptionalInt limit();

    public abstract Optional<String> searchId();

    public abstract Optional<String> searchTypeId();

    public abstract Builder toBuilder();

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timestamp", this.timestamp());
        map.put("time_range", this.timeRange());
        map.put("query_string", this.queryString());
        map.put("streams", this.streams());
        map.put("fields", this.fieldsInOrder());
        this.limit().ifPresent(limit -> map.put("limit", limit));
        this.searchId().ifPresent(searchId -> map.put("search_id", searchId));
        this.searchTypeId().ifPresent(searchTypeId -> map.put("search_type_id", searchTypeId));
        return map;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder userName(String var1);

        public abstract Builder auditType(String var1);

        public abstract Builder timestamp(DateTime var1);

        public abstract Builder timeRange(AbsoluteRange var1);

        public abstract Builder queryString(String var1);

        public abstract Builder streams(Set<String> var1);

        public abstract Builder fieldsInOrder(LinkedHashSet<String> var1);

        public abstract Builder limit(Integer var1);

        public abstract Builder searchId(String var1);

        public abstract Builder searchTypeId(String var1);

        abstract MessagesExportEvent autoBuild();

        public MessagesExportEvent build() {
            return this.autoBuild();
        }

        @JsonCreator
        public static Builder create() {
            return new AutoValue_MessagesExportEvent.Builder();
        }
    }
}

