/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.rest.AutoValue_SearchDTO;
import org.graylog.plugins.views.search.rest.QueryDTO;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class SearchDTO {
    @Nullable
    @JsonProperty
    public abstract String id();

    @JsonProperty
    public abstract LinkedHashSet<QueryDTO> queries();

    @JsonProperty
    public abstract Set<Parameter> parameters();

    @JsonProperty
    public abstract boolean skipNoStreamsCheck();

    static SearchDTO fromSearch(Search search) {
        return Builder.create().id(search.id()).parameters((Set<Parameter>)search.parameters()).queries(search.queries().stream().map(QueryDTO::fromQuery).collect(Collectors.toCollection(LinkedHashSet::new))).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    public Search toSearch() {
        ImmutableSet queries = (ImmutableSet)this.queries().stream().map(QueryDTO::toQuery).collect(ImmutableSet.toImmutableSet());
        return Search.builder().id(this.id()).queries((ImmutableSet<Query>)queries).parameters((ImmutableSet<Parameter>)ImmutableSet.copyOf(this.parameters())).skipNoStreamsCheck(this.skipNoStreamsCheck()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonProperty
        public abstract Builder id(String var1);

        public abstract String id();

        @JsonProperty
        public abstract Builder queries(LinkedHashSet<QueryDTO> var1);

        public Builder queries(QueryDTO ... queries) {
            return this.queries(new LinkedHashSet<QueryDTO>(Arrays.asList(queries)));
        }

        @JsonProperty
        public abstract Builder parameters(Set<Parameter> var1);

        @JsonProperty
        public abstract Builder skipNoStreamsCheck(boolean var1);

        public abstract SearchDTO build();

        @JsonCreator
        static Builder create() {
            return new AutoValue_SearchDTO.Builder().queries(new LinkedHashSet<QueryDTO>()).parameters((Set<Parameter>)ImmutableSet.of()).skipNoStreamsCheck(false);
        }
    }
}

