/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.GroupingToBucketSpecMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.MetricToSeriesSpecMapper;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.request.Metric;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSort;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;

public class AggregationSpecToPivotMapper
implements Function<AggregationRequestSpec, Pivot> {
    public static final String PIVOT_ID = "scripting_api_temporary_pivot";
    private final GroupingToBucketSpecMapper rowGroupCreator;
    private final MetricToSeriesSpecMapper seriesCreator;

    @Inject
    public AggregationSpecToPivotMapper(GroupingToBucketSpecMapper rowGroupCreator, MetricToSeriesSpecMapper seriesCreator) {
        this.rowGroupCreator = rowGroupCreator;
        this.seriesCreator = seriesCreator;
    }

    @Override
    public Pivot apply(AggregationRequestSpec aggregationSpec) {
        List<BucketSpec> groups = aggregationSpec.groupings().stream().map(this.rowGroupCreator).collect(Collectors.toList());
        List<ImmutablePair<Metric, SeriesSpec>> series = aggregationSpec.metrics().stream().filter(Objects::nonNull).map(m -> ImmutablePair.of((Object)m, (Object)this.seriesCreator.apply((Metric)m))).collect(Collectors.toList());
        Pivot.Builder pivotBuilder = Pivot.builder().id(PIVOT_ID).rollup(false).rowGroups(groups).series(series.stream().map(Pair::getValue).collect(Collectors.toList()));
        if (aggregationSpec.hasCustomSort()) {
            List<SortSpec> newSort = this.getSortSpecs(series);
            pivotBuilder.sort(newSort);
        }
        return pivotBuilder.build();
    }

    private List<SortSpec> getSortSpecs(List<ImmutablePair<Metric, SeriesSpec>> series) {
        return series.stream().filter(e -> ((Metric)e.getKey()).sort() != null).map(sortable -> SeriesSort.create(((SeriesSpec)sortable.getValue()).literal(), ((Metric)sortable.getKey()).sort())).collect(Collectors.toList());
    }
}

