/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.graylog2.indexer.fieldtypes.FieldTypeMapper;
import org.graylog2.indexer.fieldtypes.FieldTypes;

public enum ResponseEntryDataType {
    STRING(FieldTypeMapper.STRING_TYPE, FieldTypeMapper.STRING_FTS_TYPE),
    NUMERIC(FieldTypeMapper.LONG_TYPE, FieldTypeMapper.INT_TYPE, FieldTypeMapper.SHORT_TYPE, FieldTypeMapper.BYTE_TYPE, FieldTypeMapper.DOUBLE_TYPE, FieldTypeMapper.FLOAT_TYPE),
    DATE(FieldTypeMapper.DATE_TYPE),
    BOOLEAN(FieldTypeMapper.BOOLEAN_TYPE),
    BINARY(FieldTypeMapper.BINARY_TYPE),
    IP(FieldTypeMapper.IP_TYPE),
    GEO(FieldTypeMapper.GEO_POINT_TYPE),
    STREAM(FieldTypeMapper.STREAMS_TYPE),
    INPUT(FieldTypeMapper.INPUT_TYPE),
    NODE(FieldTypeMapper.STREAMS_TYPE),
    UNKNOWN(new FieldTypes.Type[0]);

    private final Set<FieldTypes.Type> correspondingFieldTypes;

    private ResponseEntryDataType(FieldTypes.Type ... correspondingFieldTypes) {
        this.correspondingFieldTypes = Set.of(correspondingFieldTypes);
    }

    public static ResponseEntryDataType fromFieldType(FieldTypes.Type type) {
        if (type == null) {
            return UNKNOWN;
        }
        return Arrays.stream(ResponseEntryDataType.values()).filter(dataType -> dataType.correspondingFieldTypes.stream().anyMatch(corresponding -> ResponseEntryDataType.isMatch(corresponding, type))).findFirst().orElse(UNKNOWN);
    }

    private static boolean isMatch(FieldTypes.Type corresponding, FieldTypes.Type type) {
        return corresponding.type().equals(type.type());
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

