/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.response.decorators;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.scriptingapi.request.RequestedField;
import org.graylog.plugins.views.search.rest.scriptingapi.response.decorators.FieldDecorator;
import org.graylog2.rest.resources.system.contentpacks.titles.EntityTitleService;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntitiesTitleResponse;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityIdentifier;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleRequest;
import org.graylog2.rest.resources.system.contentpacks.titles.model.EntityTitleResponse;

public class TitleDecorator
implements FieldDecorator {
    private final EntityTitleService entityTitleService;
    private static final Map<String, String> FIELD_ENTITY_MAPPER = Map.of("streams", "streams", "gl2_source_input", "inputs");

    @Inject
    public TitleDecorator(EntityTitleService entityTitleService) {
        this.entityTitleService = entityTitleService;
    }

    @Override
    public boolean accept(RequestedField field) {
        return FIELD_ENTITY_MAPPER.containsKey(field.name()) && this.acceptsDecorator(field.decorator());
    }

    private boolean acceptsDecorator(@Nullable String decorator) {
        return decorator == null || decorator.equals("title");
    }

    @Override
    public Object decorate(RequestedField field, Object value, SearchUser searchUser) {
        List<String> ids = this.parseIDs(value);
        EntityTitleRequest req = ids.stream().map(id -> new EntityIdentifier((String)id, FIELD_ENTITY_MAPPER.get(field.name()))).collect(Collectors.collectingAndThen(Collectors.toList(), EntityTitleRequest::new));
        EntitiesTitleResponse response = this.entityTitleService.getTitles(req, searchUser);
        return this.extractTitles(ids, response.entities()).stream().collect(Collectors.collectingAndThen(Collectors.toList(), titles -> value instanceof Collection ? titles : this.unwrapIfSingleResult((List<String>)titles)));
    }

    private List<String> extractTitles(List<String> ids, Set<EntityTitleResponse> entities) {
        return ids.stream().map(id -> TitleDecorator.extractTitle(entities, id)).collect(Collectors.toList());
    }

    private static String extractTitle(Set<EntityTitleResponse> entities, String id) {
        return entities.stream().filter(e -> Objects.equals(id, e.id())).findFirst().map(EntityTitleResponse::title).orElse(id);
    }

    private Object unwrapIfSingleResult(List<String> titles) {
        if (titles.size() == 1) {
            return titles.iterator().next();
        }
        return titles;
    }

    private List<String> parseIDs(Object value) {
        if (value instanceof Collection) {
            Collection col = (Collection)value;
            return col.stream().map(Object::toString).collect(Collectors.toList());
        }
        return Collections.singletonList(value.toString());
    }
}

