/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.validation;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.graylog.plugins.views.search.validation.ImmutableToken;
import org.graylog.plugins.views.search.validation.ParsedTerm;

public class TermCollectingQueryVisitor
extends QueryVisitor {
    private final Analyzer analyzer;
    private final List<ParsedTerm> parsedTerms = new ArrayList<ParsedTerm>();
    private final Map<Query, Collection<ImmutableToken>> tokenLookup;

    public TermCollectingQueryVisitor(Analyzer analyzer, Map<Query, Collection<ImmutableToken>> tokenLookup) {
        this.analyzer = analyzer;
        this.tokenLookup = tokenLookup;
    }

    public void consumeTerms(Query query, Term ... terms) {
        super.consumeTerms(query, terms);
        Collection tokens = this.tokenLookup.getOrDefault(query, Collections.emptySet());
        this.processTerms(tokens, terms);
    }

    /*
     * Unable to fully structure code
     */
    private void processTerms(Collection<ImmutableToken> tokens, Term ... terms) {
        for (Term t : terms) {
            termBuilder = ParsedTerm.builder().field(t.field()).value(t.text());
            if (t.field().equals("_default_")) ** GOTO lbl8
            if (t.field().equals("_exists_")) {
lbl8:
                // 2 sources

                tokens.stream().filter((Predicate<ImmutableToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processTerms$0(org.apache.lucene.index.Term org.graylog.plugins.views.search.validation.ImmutableToken ), (Lorg/graylog/plugins/views/search/validation/ImmutableToken;)Z)((Term)t)).findFirst().ifPresent((Consumer<ImmutableToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, keyToken(org.graylog.plugins.views.search.validation.ImmutableToken ), (Lorg/graylog/plugins/views/search/validation/ImmutableToken;)V)((ParsedTerm.Builder)termBuilder));
            } else {
                tokens.stream().filter((Predicate<ImmutableToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processTerms$1(org.graylog.plugins.views.search.validation.ImmutableToken ), (Lorg/graylog/plugins/views/search/validation/ImmutableToken;)Z)()).filter((Predicate<ImmutableToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processTerms$2(org.apache.lucene.index.Term org.graylog.plugins.views.search.validation.ImmutableToken ), (Lorg/graylog/plugins/views/search/validation/ImmutableToken;)Z)((Term)t)).findFirst().ifPresent((Consumer<ImmutableToken>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processTerms$5(org.graylog.plugins.views.search.validation.ParsedTerm$Builder org.apache.lucene.index.Term java.util.Collection org.graylog.plugins.views.search.validation.ImmutableToken ), (Lorg/graylog/plugins/views/search/validation/ImmutableToken;)V)((TermCollectingQueryVisitor)this, (ParsedTerm.Builder)termBuilder, (Term)t, tokens));
            }
            this.parsedTerms.add(termBuilder.build());
        }
    }

    private String normalize(String fieldName, String value) {
        return this.analyzer.normalize(fieldName, value).utf8ToString();
    }

    public void visitLeaf(Query query) {
        Collection<ImmutableToken> tokens = this.tokenLookup.get(query);
        if (query instanceof RegexpQuery) {
            this.processTerms(tokens, ((RegexpQuery)query).getRegexp());
        } else if (query instanceof TermRangeQuery) {
            TermRangeQuery trq = (TermRangeQuery)query;
            this.processTerms(tokens, new Term(trq.getField(), trq.getLowerTerm().utf8ToString()), new Term(trq.getField(), trq.getUpperTerm().utf8ToString()));
        } else if (query instanceof WildcardQuery) {
            this.processTerms(tokens, ((WildcardQuery)query).getTerm());
        } else if (query instanceof PrefixQuery) {
            this.processTerms(tokens, ((PrefixQuery)query).getPrefix());
        } else if (query instanceof FuzzyQuery) {
            this.processTerms(tokens, ((FuzzyQuery)query).getTerm());
        } else {
            throw new IllegalArgumentException("Unrecognized query type: " + query.getClass().getName());
        }
    }

    public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
        return this;
    }

    public List<ParsedTerm> getParsedTerms() {
        return this.parsedTerms;
    }

    private /* synthetic */ void lambda$processTerms$5(ParsedTerm.Builder termBuilder, Term t, Collection tokens, ImmutableToken token) {
        termBuilder.keyToken(token);
        String value = t.text();
        tokens.stream().filter(v -> v.kind() == 20).filter(v -> this.normalize(t.field(), v.image()).equals(value)).findFirst().ifPresent(termBuilder::valueToken);
    }

    private static /* synthetic */ boolean lambda$processTerms$2(Term t, ImmutableToken token) {
        return token.image().equals(t.field());
    }

    private static /* synthetic */ boolean lambda$processTerms$1(ImmutableToken token) {
        return token.kind() == 20;
    }

    private static /* synthetic */ boolean lambda$processTerms$0(Term t, ImmutableToken token) {
        return token.matches(20, t.text());
    }
}

