/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.actions;

import com.fasterxml.jackson.annotation.JsonProperty;

public record TrafficSnapshot(@JsonProperty(value="start_bytes") long startInputBytes, @JsonProperty(value="start_ts") long startTimestamp) {
    public static final String TRAFFIC_SNAPSHOT = "traffic_snapshot";
    public static final String ESTIMATED_TRAFFIC_PER_MINUTE = "estimated_traffic";

    public TrafficSnapshot(long startInputBytes) {
        this(startInputBytes, System.currentTimeMillis());
    }

    public long calculateEstimatedTrafficPerMinute(long currentInputBytes) {
        return this.calculateEstimatedTrafficPerMinute(currentInputBytes, System.currentTimeMillis());
    }

    long calculateEstimatedTrafficPerMinute(long currentInputBytes, long endTimestamp) {
        double elapsedTimeMin = (double)(endTimestamp - this.startTimestamp) / 60000.0;
        long inputTraffic = currentInputBytes - this.startInputBytes;
        return (long)((double)inputTraffic / elapsedTimeMin);
    }
}

