/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.machine;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStep;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.PROTECTED_AND_PUBLIC)
public class MigrationStateMachineContext {
    public static final String AUTH_TOKEN_KEY = "authToken";
    public static final String KEY_MIGRATION_ID = "migrationID";
    public static final String KEY_COMPATIBILITY_CHECK_PASSED = "compatibilityCheckResult";
    @JsonProperty
    protected MigrationStep currentStep;
    @JsonProperty
    protected Map<MigrationStep, Map<String, Object>> actionArguments = new HashMap<MigrationStep, Map<String, Object>>();
    @JsonProperty
    protected Map<String, Object> extendedState = new HashMap<String, Object>();
    @JsonIgnore
    protected Object response;

    public void setCurrentStep(MigrationStep currentStep) {
        this.currentStep = currentStep;
    }

    public <T> T getActionArgument(String name, Class<T> type) {
        Map<String, Object> args = this.actionArguments.get((Object)this.currentStep);
        if (Objects.isNull(args)) {
            throw new IllegalArgumentException("Missing arguments for step " + String.valueOf((Object)this.currentStep));
        }
        if (!args.containsKey(name)) {
            throw new IllegalArgumentException("Missing argument " + name + " for step " + String.valueOf((Object)this.currentStep));
        }
        Object arg = args.get(name);
        if (!type.isInstance(arg)) {
            throw new IllegalArgumentException("Argument " + name + " must be of type " + String.valueOf(type));
        }
        return (T)arg;
    }

    public <T> Optional<T> getActionArgumentOpt(String name, Class<T> type) {
        Map<String, Object> args = this.actionArguments.get((Object)this.currentStep);
        return Optional.ofNullable(args).map(arg -> arg.get(name)).map(arg -> {
            if (!type.isInstance(arg)) {
                throw new IllegalArgumentException("Argument " + name + " must be of type " + String.valueOf(type));
            }
            return arg;
        });
    }

    public void addActionArguments(MigrationStep step, Map<String, Object> args) {
        this.actionArguments.put(step, args);
    }

    public void addExtendedState(String key, Object value) {
        this.extendedState.put(key, value);
    }

    public Object getExtendedState(String key) {
        return this.extendedState.get(key);
    }

    public <T> Optional<T> getExtendedState(String name, Class<T> type) {
        if (!this.extendedState.containsKey(name)) {
            return Optional.empty();
        }
        Object value = this.extendedState.get(name);
        if (!type.isInstance(value)) {
            if (value instanceof LinkedHashMap) {
                LinkedHashMap map = (LinkedHashMap)value;
                try {
                    return Optional.of(new ObjectMapper().convertValue((Object)map, type));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Argument " + name + " must be of type " + String.valueOf(type));
                }
            }
            throw new IllegalArgumentException("Argument " + name + " must be of type " + String.valueOf(type));
        }
        return Optional.of(value);
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public Object getResponse() {
        return this.response;
    }
}

