/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.storage.migration.state.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog.plugins.views.storage.migration.state.machine.MigrationStateMachine;
import org.graylog.plugins.views.storage.migration.state.rest.CurrentStateInformation;
import org.graylog.plugins.views.storage.migration.state.rest.MigrationStepRequest;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.shared.rest.resources.ProxiedResource;

@Path(value="/migration")
@RequiresAuthentication
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Api(value="Migration", description="Resource for managing migration to datanode from open/elasticsearch")
public class MigrationStateResource {
    private final MigrationStateMachine stateMachine;

    @Inject
    public MigrationStateResource(MigrationStateMachine stateMachine, @Context HttpHeaders httpHeaders) {
        this.stateMachine = stateMachine;
        this.stateMachine.getContext().addExtendedState("authToken", ProxiedResource.authenticationToken(httpHeaders));
    }

    @POST
    @Path(value="/trigger")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="trigger migration step")
    public Response trigger(@ApiParam(name="request") @NotNull MigrationStepRequest request) {
        CurrentStateInformation newState = this.stateMachine.trigger(request.step(), request.args());
        Response.ResponseBuilder response = newState.hasErrors() ? Response.serverError() : Response.ok();
        return response.entity((Object)newState).build();
    }

    @GET
    @Path(value="/state")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="Migration status", notes="Current status of the datanode migration")
    public CurrentStateInformation status() {
        return new CurrentStateInformation(this.stateMachine.getState(), this.stateMachine.nextSteps());
    }

    @GET
    @Path(value="/serialize")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @Produces(value={"text/plain"})
    @ApiOperation(value="Serialize", notes="Serialize migration graph as graphviz source")
    public String serialize() {
        return this.stateMachine.serialize();
    }

    @DELETE
    @Path(value="/state")
    @NoAuditEvent(value="No Audit Event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="Reset the whole migration to the first step, start over")
    public CurrentStateInformation resetState() {
        this.stateMachine.reset();
        return new CurrentStateInformation(this.stateMachine.getState(), this.stateMachine.nextSteps());
    }

    @GET
    @Path(value="/journalestimate")
    @NoAuditEvent(value="No audit event needed")
    @RequiresPermissions(value={"datanode:migration"})
    @ApiOperation(value="Get journal size estimate (bytes/minute)")
    public long getTrafficPerMinute() {
        return this.stateMachine.getContext().getExtendedState("estimated_traffic", Long.class).orElse(0L);
    }
}

