/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security;

import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.shiro.authz.Permission;
import org.graylog.grn.GRN;
import org.graylog.security.BuiltinCapabilities;
import org.graylog.security.CapabilityDescriptor;
import org.graylog.security.DBGrantService;
import org.graylog.security.GrantDTO;
import org.graylog.security.PermissionAndRoleResolver;
import org.graylog.security.permissions.CaseSensitiveWildcardPermission;
import org.graylog.security.permissions.GRNPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionAndRoleResolver
implements PermissionAndRoleResolver {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPermissionAndRoleResolver.class);
    private final Logger logger;
    private final BuiltinCapabilities builtinCapabilities;
    private final DBGrantService grantService;

    @Inject
    public DefaultPermissionAndRoleResolver(BuiltinCapabilities builtinCapabilities, DBGrantService grantService) {
        this(LOG, builtinCapabilities, grantService);
    }

    public DefaultPermissionAndRoleResolver(Logger logger, BuiltinCapabilities builtinCapabilities, DBGrantService grantService) {
        this.logger = logger;
        this.builtinCapabilities = builtinCapabilities;
        this.grantService = grantService;
    }

    protected Set<GRN> resolveTargets(GRN target) {
        switch (target.type()) {
            case "system": {
                return Collections.emptySet();
            }
        }
        return Collections.singleton(target);
    }

    @Override
    public Set<GRN> resolveGrantees(GRN principal) {
        return Collections.singleton(principal);
    }

    @Override
    public Set<Permission> resolvePermissionsForPrincipal(GRN principal) {
        ImmutableSet<GrantDTO> grants = this.grantService.getForGranteesOrGlobal(this.resolveGrantees(principal));
        ImmutableSet.Builder permissionsBuilder = ImmutableSet.builder();
        for (GrantDTO grant : grants) {
            Optional<CapabilityDescriptor> capability = this.builtinCapabilities.get(grant.capability());
            if (capability.isPresent()) {
                Set<GRN> targets = this.resolveTargets(grant.target());
                for (String permission : capability.get().permissions()) {
                    for (GRN target : targets) {
                        if (!target.isPermissionApplicable(permission)) continue;
                        if (permission.equals("entity:own")) {
                            permissionsBuilder.add((Object)GRNPermission.create(permission, target));
                            continue;
                        }
                        permissionsBuilder.add((Object)new CaseSensitiveWildcardPermission(permission + ":" + target.entity()));
                    }
                }
                continue;
            }
            this.logger.warn("Couldn't find capability <{}>", (Object)grant.capability());
        }
        return permissionsBuilder.build();
    }

    @Override
    public Set<String> resolveRolesForPrincipal(GRN principal) {
        return ImmutableSet.of();
    }
}

