/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.KeyPair;

public class CertificateGenerator {
    public static KeyPair generate(CertRequest request) throws Exception {
        PrivateKey issuerKey;
        X500Name issuerName;
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        java.security.KeyPair certKeyPair = keyGen.generateKeyPair();
        X500Name name = CertificateGenerator.getX500Name(request.cnName());
        BigInteger serialNumber = BigInteger.valueOf(System.currentTimeMillis());
        Instant validFrom = Instant.now();
        Instant validUntil = validFrom.plus(request.validity());
        if (request.issuer() == null) {
            issuerName = name;
            issuerKey = certKeyPair.getPrivate();
        } else {
            issuerName = new X500Name(request.issuer().certificate().getSubjectX500Principal().getName());
            issuerKey = request.issuer().privateKey();
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerName, serialNumber, Date.from(validFrom), Date.from(validUntil), name, certKeyPair.getPublic());
        if (request.isCA()) {
            builder.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true));
        }
        if (!request.subjectAlternativeNames().isEmpty()) {
            GeneralName[] generalNames = (GeneralName[])request.subjectAlternativeNames().stream().map(s -> new GeneralName(2, s)).toArray(GeneralName[]::new);
            builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(generalNames));
        }
        ContentSigner signer = new JcaContentSignerBuilder("SHA256withRSA").build(issuerKey);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHolder);
        return new KeyPair(certKeyPair.getPrivate(), certKeyPair.getPublic(), cert);
    }

    private static X500Name getX500Name(String cname) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.CN, cname);
        return builder.build();
    }
}

