/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.keystore.storage;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Enumeration;
import org.graylog.security.certutil.keystore.storage.KeystoreContentMover;

public class SinglePasswordKeystoreContentMover
implements KeystoreContentMover {
    @Override
    public KeyStore moveContents(KeyStore originalKeyStore, char[] currentPassword, char[] newPassword) throws GeneralSecurityException, IOException {
        if (newPassword == null) {
            throw new IllegalArgumentException("new password cannot be null");
        }
        KeyStore newKeyStore = KeyStore.getInstance("PKCS12");
        newKeyStore.load(null, newPassword);
        Enumeration<String> aliases = originalKeyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (originalKeyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                newKeyStore.setKeyEntry(alias, originalKeyStore.getKey(alias, currentPassword), newPassword, originalKeyStore.getCertificateChain(alias));
                continue;
            }
            if (originalKeyStore.entryInstanceOf(alias, KeyStore.TrustedCertificateEntry.class)) {
                newKeyStore.setCertificateEntry(alias, originalKeyStore.getCertificate(alias));
                continue;
            }
            if (!originalKeyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) continue;
            newKeyStore.setEntry(alias, originalKeyStore.getEntry(alias, new KeyStore.PasswordProtection(currentPassword)), new KeyStore.PasswordProtection(newPassword));
        }
        return newKeyStore;
    }
}

