/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.privatekey;

import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.jcajce.JcaPKCS8EncryptedPrivateKeyInfoBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEInputDecryptorProviderBuilder;
import org.bouncycastle.pkcs.jcajce.JcePKCSPBEOutputEncryptorBuilder;
import org.graylog.security.certutil.privatekey.PrivateKeyEncryptedStorage;

public record PrivateKeyEncryptedFileStorage(Path privateKeyFilename) implements PrivateKeyEncryptedStorage
{
    @Override
    public void writeEncryptedKey(char[] password, PrivateKey privateKey) throws IOException, OperatorCreationException {
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)new FileWriter(this.privateKeyFilename.toFile(), Charset.defaultCharset()));
        JcaPKCS8EncryptedPrivateKeyInfoBuilder pkcs8Builder = new JcaPKCS8EncryptedPrivateKeyInfoBuilder(privateKey);
        pemWriter.writeObject((Object)pkcs8Builder.build(new JcePKCSPBEOutputEncryptorBuilder(NISTObjectIdentifiers.id_aes256_CBC).setProvider("BC").build(password)));
        pemWriter.close();
    }

    @Override
    public PrivateKey readEncryptedKey(char[] password) throws IOException, PKCSException {
        PEMParser parser = new PEMParser((Reader)new FileReader(this.privateKeyFilename.toFile(), Charset.defaultCharset()));
        PKCS8EncryptedPrivateKeyInfo encPrivKeyInfo = (PKCS8EncryptedPrivateKeyInfo)parser.readObject();
        InputDecryptorProvider pkcs8Prov = new JcePKCSPBEInputDecryptorProviderBuilder().setProvider("BC").build(password);
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getPrivateKey(encPrivKeyInfo.decryptPrivateKeyInfo(pkcs8Prov));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

