/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bindings.providers;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.util.Map;
import org.graylog2.plugin.security.PasswordAlgorithm;

public class DefaultPasswordAlgorithmProvider
implements Provider<PasswordAlgorithm> {
    private final PasswordAlgorithm defaultPasswordAlgorithm;

    @Inject
    public DefaultPasswordAlgorithmProvider(@Named(value="user_password_default_algorithm") String defaultPasswordAlgorithmName, Map<String, PasswordAlgorithm> passwordAlgorithms) {
        if (!passwordAlgorithms.containsKey(defaultPasswordAlgorithmName)) {
            throw new IllegalArgumentException("Invalid default password hashing specified in config. Found: " + defaultPasswordAlgorithmName + ". Valid options: " + String.valueOf(passwordAlgorithms.keySet()));
        }
        this.defaultPasswordAlgorithm = passwordAlgorithms.get(defaultPasswordAlgorithmName);
    }

    public PasswordAlgorithm get() {
        return this.defaultPasswordAlgorithm;
    }
}

