/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.github.joschi.jadconfig.Parameter;
import com.github.joschi.jadconfig.util.Duration;
import com.github.joschi.jadconfig.validators.PositiveDurationValidator;
import com.github.joschi.jadconfig.validators.PositiveIntegerValidator;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.graylog2.configuration.converters.MajorVersionConverter;
import org.graylog2.configuration.converters.URIListConverter;
import org.graylog2.configuration.validators.ElasticsearchVersionValidator;
import org.graylog2.configuration.validators.HttpOrHttpsSchemeValidator;
import org.graylog2.configuration.validators.ListOfURIsWithHostAndSchemeValidator;
import org.graylog2.storage.SearchVersion;

public class ElasticsearchClientConfiguration {
    @Parameter(value="elasticsearch_version", converter=MajorVersionConverter.class, validators={ElasticsearchVersionValidator.class})
    private SearchVersion elasticsearchVersion;
    @Parameter(value="elasticsearch_hosts", converter=URIListConverter.class, validators={ListOfURIsWithHostAndSchemeValidator.class})
    private List<URI> elasticsearchHosts = new ArrayList<URI>();
    @Parameter(value="elasticsearch_connect_timeout", validators={PositiveDurationValidator.class})
    private Duration elasticsearchConnectTimeout = Duration.seconds((long)10L);
    @Parameter(value="elasticsearch_socket_timeout", validators={PositiveDurationValidator.class})
    private Duration elasticsearchSocketTimeout = Duration.seconds((long)60L);
    @Parameter(value="elasticsearch_idle_timeout")
    private Duration elasticsearchIdleTimeout = Duration.seconds((long)-1L);
    @Parameter(value="elasticsearch_version_probe_attempts", validators={PositiveIntegerValidator.class})
    private int elasticsearchVersionProbeAttempts = 0;
    @Parameter(value="elasticsearch_version_probe_delay", validators={PositiveDurationValidator.class})
    private Duration elasticsearchVersionProbeDelay = Duration.seconds((long)5L);
    @Parameter(value="datanode_startup_connection_attempts", fallbackPropertyName="elasticsearch_version_probe_attempts", validators={PositiveIntegerValidator.class})
    private int datanodeStartupConnectionAttempts = 0;
    @Parameter(value="datanode_startup_connection_delay", fallbackPropertyName="elasticsearch_version_probe_delay", validators={PositiveDurationValidator.class})
    private Duration datanodeStartupConnectionDelay = Duration.seconds((long)5L);
    @Parameter(value="elasticsearch_max_total_connections", validators={PositiveIntegerValidator.class})
    private int elasticsearchMaxTotalConnections = 200;
    @Parameter(value="elasticsearch_max_total_connections_per_route", validators={PositiveIntegerValidator.class})
    private int elasticsearchMaxTotalConnectionsPerRoute = 20;
    @Parameter(value="elasticsearch_max_retries", validators={PositiveIntegerValidator.class})
    private int elasticsearchMaxRetries = 2;
    @Parameter(value="elasticsearch_discovery_enabled")
    private boolean discoveryEnabled = false;
    @Parameter(value="elasticsearch_node_activity_logger_enabled")
    private boolean nodeActivityLogger = false;
    @Parameter(value="elasticsearch_discovery_filter")
    private String discoveryFilter = null;
    @Parameter(value="elasticsearch_discovery_frequency", validators={PositiveDurationValidator.class})
    private Duration discoveryFrequency = Duration.seconds((long)30L);
    @Parameter(value="elasticsearch_discovery_default_scheme", validators={HttpOrHttpsSchemeValidator.class})
    private String defaultSchemeForDiscoveredNodes = "http";
    @Parameter(value="elasticsearch_discovery_default_user")
    private String defaultUserForDiscoveredNodes = null;
    @Parameter(value="elasticsearch_discovery_default_password")
    private String defaultPasswordForDiscoveredNodes = null;
    @Parameter(value="elasticsearch_compression_enabled")
    private boolean compressionEnabled = false;
    @Parameter(value="elasticsearch_use_expect_continue")
    private boolean useExpectContinue = true;
    @Parameter(value="elasticsearch_mute_deprecation_warnings")
    private boolean muteDeprecationWarnings = false;
    @Parameter(value="indexer_use_jwt_authentication")
    private boolean indexerUseJwtAuthentication = false;
    @Parameter(value="indexer_jwt_auth_token_caching_duration")
    private Duration indexerJwtAuthTokenCachingDuration = Duration.seconds((long)60L);
    @Parameter(value="indexer_jwt_auth_token_expiration_duration")
    private Duration indexerJwtAuthTokenExpirationDuration = Duration.seconds((long)180L);
    @Parameter(value="indexer_max_concurrent_searches")
    private Integer indexerMaxConcurrentSearches = null;
    @Parameter(value="indexer_max_concurrent_shard_requests")
    private Integer indexerMaxConcurrentShardRequests = null;

    public SearchVersion elasticsearchVersion() {
        return this.elasticsearchVersion;
    }

    public List<URI> elasticsearchHosts() {
        return this.elasticsearchHosts;
    }

    public Duration elasticsearchConnectTimeout() {
        return this.elasticsearchConnectTimeout;
    }

    public Duration elasticsearchSocketTimeout() {
        return this.elasticsearchSocketTimeout;
    }

    public Duration elasticsearchIdleTimeout() {
        return this.elasticsearchIdleTimeout;
    }

    public int elasticsearchVersionProbeAttempts() {
        return this.elasticsearchVersionProbeAttempts;
    }

    public Duration elasticsearchVersionProbeDelay() {
        return this.elasticsearchVersionProbeDelay;
    }

    public int getDatanodeStartupConnectionAttempts() {
        return this.datanodeStartupConnectionAttempts;
    }

    public Duration getDatanodeStartupConnectionDelay() {
        return this.datanodeStartupConnectionDelay;
    }

    public int elasticsearchMaxTotalConnections() {
        return this.elasticsearchMaxTotalConnections;
    }

    public int elasticsearchMaxTotalConnectionsPerRoute() {
        return this.elasticsearchMaxTotalConnectionsPerRoute;
    }

    public int elasticsearchMaxRetries() {
        return this.elasticsearchMaxRetries;
    }

    public boolean discoveryEnabled() {
        return this.discoveryEnabled;
    }

    public boolean isNodeActivityLogger() {
        return this.nodeActivityLogger;
    }

    public String discoveryFilter() {
        return this.discoveryFilter;
    }

    public Duration discoveryFrequency() {
        return this.discoveryFrequency;
    }

    public String defaultSchemeForDiscoveredNodes() {
        return this.defaultSchemeForDiscoveredNodes;
    }

    public String defaultUserForDiscoveredNodes() {
        return this.defaultUserForDiscoveredNodes;
    }

    public String defaultPasswordForDiscoveredNodes() {
        return this.defaultPasswordForDiscoveredNodes;
    }

    public boolean compressionEnabled() {
        return this.compressionEnabled;
    }

    public boolean useExpectContinue() {
        return this.useExpectContinue;
    }

    public boolean muteDeprecationWarnings() {
        return this.muteDeprecationWarnings;
    }

    public boolean indexerUseJwtAuthentication() {
        return this.indexerUseJwtAuthentication;
    }

    public Duration indexerJwtAuthTokenCachingDuration() {
        return this.indexerJwtAuthTokenCachingDuration;
    }

    public Duration indexerJwtAuthTokenExpirationDuration() {
        return this.indexerJwtAuthTokenExpirationDuration;
    }

    public Integer indexerMaxConcurrentSearches() {
        return this.indexerMaxConcurrentSearches;
    }

    public Integer indexerMaxConcurrentShardRequests() {
        return this.indexerMaxConcurrentShardRequests;
    }
}

