/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.validators;

import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.graylog2.configuration.validators.SearchVersionRange;
import org.graylog2.storage.SearchVersion;

public class ElasticsearchVersionValidator
implements Validator<SearchVersion> {
    public static final List<SearchVersionRange> SUPPORTED_ES_VERSIONS = ImmutableList.of((Object)SearchVersionRange.of(SearchVersion.Distribution.OPENSEARCH, "^1.0.0"), (Object)SearchVersionRange.of(SearchVersion.Distribution.OPENSEARCH, "^2.0.0"), (Object)SearchVersionRange.of(SearchVersion.Distribution.ELASTICSEARCH, "^7.0.0"), (Object)SearchVersionRange.of(SearchVersion.Distribution.DATANODE, "^5.2.0"));

    public void validate(String name, SearchVersion value) throws ValidationException {
        if (SUPPORTED_ES_VERSIONS.stream().noneMatch(value::satisfies)) {
            throw new ValidationException("Invalid Search version specified in " + name + ": " + String.valueOf(value) + ". Supported versions: " + String.valueOf(SUPPORTED_ES_VERSIONS));
        }
    }
}

