/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.facades;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.sidecar.rest.models.Collector;
import org.graylog.plugins.sidecar.rest.models.Configuration;
import org.graylog.plugins.sidecar.services.ConfigurationService;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelType;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.SidecarCollectorConfigurationEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidecarCollectorConfigurationFacade
implements EntityFacade<Configuration> {
    private static final Logger LOG = LoggerFactory.getLogger(SidecarCollectorConfigurationFacade.class);
    public static final ModelType TYPE_V1 = ModelTypes.SIDECAR_COLLECTOR_CONFIGURATION_V1;
    private final ObjectMapper objectMapper;
    private final ConfigurationService configurationService;

    @Inject
    public SidecarCollectorConfigurationFacade(ObjectMapper objectMapper, ConfigurationService configurationService) {
        this.objectMapper = objectMapper;
        this.configurationService = configurationService;
    }

    @VisibleForTesting
    Entity exportNativeEntity(Configuration configuration, EntityDescriptorIds entityDescriptorIds) {
        SidecarCollectorConfigurationEntity configurationEntity = SidecarCollectorConfigurationEntity.create(ValueReference.of(entityDescriptorIds.getOrThrow(configuration.collectorId(), ModelTypes.SIDECAR_COLLECTOR_V1)), ValueReference.of(configuration.name()), ValueReference.of(configuration.color()), ValueReference.of(configuration.template()));
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)configurationEntity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(configuration.id(), ModelTypes.SIDECAR_COLLECTOR_CONFIGURATION_V1)))).type(TYPE_V1)).data(data).build();
    }

    @Override
    public NativeEntity<Configuration> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            return this.decode((EntityV1)entity, parameters, nativeEntities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + String.valueOf(entity.getClass()));
    }

    private NativeEntity<Configuration> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        SidecarCollectorConfigurationEntity configurationEntity = (SidecarCollectorConfigurationEntity)this.objectMapper.convertValue((Object)entity.data(), SidecarCollectorConfigurationEntity.class);
        String collectorEntityId = configurationEntity.collectorId().asString(parameters);
        String collectorDbId = nativeEntities.entrySet().stream().filter(entry -> ((EntityDescriptor)entry.getKey()).id().id().equals(collectorEntityId)).map(Map.Entry::getValue).map(collector -> ((Collector)collector).id()).findFirst().orElseThrow(() -> new IllegalArgumentException(StringUtils.f("Unable to find database ID of Collector with logical ID [%s]", collectorEntityId)));
        Configuration configuration = Configuration.createWithoutId(collectorDbId, configurationEntity.title().asString(parameters), configurationEntity.color().asString(parameters), configurationEntity.template().asString(parameters), Set.of());
        Configuration savedConfiguration = this.configurationService.save(configuration);
        return NativeEntity.create(entity.id(), savedConfiguration.id(), TYPE_V1, configuration.name(), savedConfiguration);
    }

    @Override
    public Optional<NativeEntity<Configuration>> findExisting(Entity entity, Map<String, ValueReference> parameters) {
        return Optional.empty();
    }

    @Override
    public Optional<NativeEntity<Configuration>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        return this.configurationService.get(nativeEntityDescriptor.id().id()).map(entity -> NativeEntity.create(nativeEntityDescriptor, entity));
    }

    @Override
    public void delete(Configuration nativeEntity) {
        this.configurationService.delete(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(Configuration configuration) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(configuration.id()))).type(TYPE_V1)).title(configuration.name()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.configurationService.all().stream().map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Configuration configuration = this.configurationService.find(modelId.id());
        if (Objects.isNull(configuration)) {
            LOG.debug("Couldn't find collector configuration {}", (Object)entityDescriptor);
            return Optional.empty();
        }
        return Optional.of(this.exportNativeEntity(configuration, entityDescriptorIds));
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        Configuration configuration = this.configurationService.find(modelId.id());
        if (Objects.isNull(configuration)) {
            LOG.debug("Could not find configuration {}", (Object)entityDescriptor);
        } else {
            EntityDescriptor collectorEntityDescriptor = EntityDescriptor.create(configuration.collectorId(), ModelTypes.SIDECAR_COLLECTOR_V1);
            mutableGraph.putEdge((Object)entityDescriptor, (Object)collectorEntityDescriptor);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveEntityV1((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + String.valueOf(entity.getClass()));
    }

    private Graph<Entity> resolveEntityV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entity);
        SidecarCollectorConfigurationEntity configurationEntity = (SidecarCollectorConfigurationEntity)this.objectMapper.convertValue((Object)entity.data(), SidecarCollectorConfigurationEntity.class);
        EntityDescriptor collectorDescriptor = EntityDescriptor.create(configurationEntity.collectorId().asString(parameters), ModelTypes.SIDECAR_COLLECTOR_V1);
        Entity collectorEntity = entities.get(collectorDescriptor);
        if (collectorEntity != null) {
            mutableGraph.putEdge((Object)entity, (Object)collectorEntity);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }
}

