/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog2.contentpacks.model.entities.QueryEntity;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

final class AutoValue_QueryEntity
extends QueryEntity {
    private final String id;
    private final TimeRange timerange;
    @Nullable
    private final Filter filter;
    private final List<UsedSearchFilter> filters;
    private final BackendQuery query;
    private final Optional<GlobalOverride> globalOverride;
    private final ImmutableSet<SearchTypeEntity> searchTypes;

    private AutoValue_QueryEntity(String id, TimeRange timerange, @Nullable Filter filter, List<UsedSearchFilter> filters, BackendQuery query, Optional<GlobalOverride> globalOverride, ImmutableSet<SearchTypeEntity> searchTypes) {
        this.id = id;
        this.timerange = timerange;
        this.filter = filter;
        this.filters = filters;
        this.query = query;
        this.globalOverride = globalOverride;
        this.searchTypes = searchTypes;
    }

    @Override
    @JsonProperty
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty
    public TimeRange timerange() {
        return this.timerange;
    }

    @Override
    @JsonProperty
    @Nullable
    public Filter filter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    public List<UsedSearchFilter> filters() {
        return this.filters;
    }

    @Override
    @JsonProperty
    @Nonnull
    public BackendQuery query() {
        return this.query;
    }

    @Override
    @JsonIgnore
    public Optional<GlobalOverride> globalOverride() {
        return this.globalOverride;
    }

    @Override
    @JsonProperty(value="search_types")
    @Nonnull
    public ImmutableSet<SearchTypeEntity> searchTypes() {
        return this.searchTypes;
    }

    public String toString() {
        return "QueryEntity{id=" + this.id + ", timerange=" + String.valueOf(this.timerange) + ", filter=" + String.valueOf(this.filter) + ", filters=" + String.valueOf(this.filters) + ", query=" + String.valueOf(this.query) + ", globalOverride=" + String.valueOf(this.globalOverride) + ", searchTypes=" + String.valueOf(this.searchTypes) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueryEntity) {
            QueryEntity that = (QueryEntity)o;
            return this.id.equals(that.id()) && this.timerange.equals(that.timerange()) && (this.filter == null ? that.filter() == null : this.filter.equals(that.filter())) && this.filters.equals(that.filters()) && this.query.equals(that.query()) && this.globalOverride.equals(that.globalOverride()) && this.searchTypes.equals(that.searchTypes());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.id.hashCode();
        h$ *= 1000003;
        h$ ^= this.timerange.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter == null ? 0 : this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.filters.hashCode();
        h$ *= 1000003;
        h$ ^= this.query.hashCode();
        h$ *= 1000003;
        h$ ^= this.globalOverride.hashCode();
        h$ *= 1000003;
        return h$ ^= this.searchTypes.hashCode();
    }

    @Override
    public QueryEntity.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends QueryEntity.Builder {
        private String id;
        private TimeRange timerange;
        private Filter filter;
        private List<UsedSearchFilter> filters;
        private BackendQuery query;
        private Optional<GlobalOverride> globalOverride = Optional.empty();
        private ImmutableSet<SearchTypeEntity> searchTypes;

        Builder() {
        }

        private Builder(QueryEntity source) {
            this.id = source.id();
            this.timerange = source.timerange();
            this.filter = source.filter();
            this.filters = source.filters();
            this.query = source.query();
            this.globalOverride = source.globalOverride();
            this.searchTypes = source.searchTypes();
        }

        @Override
        public QueryEntity.Builder id(String id) {
            if (id == null) {
                throw new NullPointerException("Null id");
            }
            this.id = id;
            return this;
        }

        @Override
        public QueryEntity.Builder timerange(TimeRange timerange) {
            if (timerange == null) {
                throw new NullPointerException("Null timerange");
            }
            this.timerange = timerange;
            return this;
        }

        @Override
        public QueryEntity.Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public QueryEntity.Builder filters(List<UsedSearchFilter> filters) {
            if (filters == null) {
                throw new NullPointerException("Null filters");
            }
            this.filters = filters;
            return this;
        }

        @Override
        public QueryEntity.Builder query(BackendQuery query) {
            if (query == null) {
                throw new NullPointerException("Null query");
            }
            this.query = query;
            return this;
        }

        @Override
        public QueryEntity.Builder globalOverride(@Nullable GlobalOverride globalOverride) {
            this.globalOverride = Optional.ofNullable(globalOverride);
            return this;
        }

        @Override
        public QueryEntity.Builder searchTypes(@Nullable Set<SearchTypeEntity> searchTypes) {
            this.searchTypes = ImmutableSet.copyOf(searchTypes);
            return this;
        }

        @Override
        QueryEntity autoBuild() {
            if (this.id == null || this.timerange == null || this.filters == null || this.query == null || this.searchTypes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.id == null) {
                    missing.append(" id");
                }
                if (this.timerange == null) {
                    missing.append(" timerange");
                }
                if (this.filters == null) {
                    missing.append(" filters");
                }
                if (this.query == null) {
                    missing.append(" query");
                }
                if (this.searchTypes == null) {
                    missing.append(" searchTypes");
                }
                throw new IllegalStateException("Missing required properties:" + String.valueOf(missing));
            }
            return new AutoValue_QueryEntity(this.id, this.timerange, this.filter, this.filters, this.query, this.globalOverride, this.searchTypes);
        }
    }
}

