/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import org.graylog2.contentpacks.model.ContentPack;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.ModelVersion;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.GraylogVersionConstraint;
import org.graylog2.contentpacks.model.entities.AutoValue_EntityV1;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;

@JsonAutoDetect
@JsonDeserialize(builder=AutoValue_EntityV1.Builder.class)
@AutoValue
public abstract class EntityV1
implements Entity {
    public static final String VERSION = "1";
    public static final String FIELD_DATA = "data";
    public static final String FIELD_CONSTRAINTS = "constraints";

    @JsonProperty(value="data")
    public abstract JsonNode data();

    @JsonProperty(value="constraints")
    public abstract ImmutableSet<Constraint> constraints();

    @Override
    public EntityDescriptor toEntityDescriptor() {
        return ((EntityDescriptor.Builder)((EntityDescriptor.Builder)EntityDescriptor.builder().id(this.id())).type(this.type())).build();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_EntityV1.Builder().constraints((ImmutableSet<Constraint>)ImmutableSet.builder().add((Object)GraylogVersionConstraint.currentGraylogVersion()).build());
    }

    public static Entity createRoot(ContentPack contentPack) {
        return ((Builder)((Builder)EntityV1.builder().type(ModelTypes.ROOT)).id(ModelId.of("virtual-root-" + String.valueOf(contentPack.id()) + "-" + contentPack.revision()))).data((JsonNode)NullNode.getInstance()).constraints((ImmutableSet<Constraint>)ImmutableSet.of()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements Entity.EntityBuilder<Builder> {
        @JsonProperty(value="data")
        public abstract Builder data(JsonNode var1);

        @JsonProperty(value="constraints")
        public abstract Builder constraints(ImmutableSet<Constraint> var1);

        abstract EntityV1 autoBuild();

        public EntityV1 build() {
            this.version(ModelVersion.of(EntityV1.VERSION));
            EntityV1 entityV1 = this.autoBuild();
            if (this.missesServerConstraint(entityV1)) {
                return entityV1.toBuilder().constraints((ImmutableSet<Constraint>)ImmutableSet.builder().addAll(entityV1.constraints()).add((Object)GraylogVersionConstraint.currentGraylogVersion()).build()).build();
            }
            return entityV1;
        }

        private boolean missesServerConstraint(EntityV1 entityV1) {
            return entityV1.constraints().stream().map(Constraint::type).noneMatch("server-version"::equals);
        }
    }
}

