/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentstream.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.contentstream.rest.ContentStreamService;
import org.graylog2.contentstream.rest.ContentStreamSettings;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.shared.users.UserService;

@RequiresAuthentication
@Api(value="ContentStream", description="Content Stream", tags={"cloud"})
@Path(value="/contentstream/")
@Produces(value={"application/json"})
public class ContentStreamResource
extends RestResource {
    private final ContentStreamService contentStreamService;

    @Inject
    protected ContentStreamResource(ContentStreamService contentStreamService, UserService userService) {
        this.contentStreamService = contentStreamService;
        this.userService = userService;
    }

    @GET
    @Path(value="tags")
    @ApiOperation(value="Retrieve valid feed tags based on license")
    public List<String> getContentStreamTags() throws NotFoundException {
        return this.contentStreamService.getTags();
    }

    @GET
    @Path(value="settings/{username}")
    @ApiOperation(value="Retrieve Content Stream settings for specified user")
    public ContentStreamSettings getContentStreamUserSettings(@ApiParam(name="username") @PathParam(value="username") String username) throws NotFoundException {
        if (this.isPermitted("users:edit", username)) {
            return this.contentStreamService.getUserSettings(this.loadUser(username));
        }
        throw new ForbiddenException("Not allowed to view user " + username);
    }

    @PUT
    @Path(value="settings/{username}")
    @ApiOperation(value="Update Content Stream settings for specified user")
    @AuditEvent(type="server:content_stream_user_settings:update")
    public ContentStreamSettings setContentStreamUserSettings(@ApiParam(name="username") @PathParam(value="username") String username, @ApiParam(name="JSON body", value="Content Stream settings for the specified user.", required=true) @Valid @NotNull ContentStreamSettings settings) throws NotFoundException {
        if (this.isPermitted("users:edit", username)) {
            User user = this.loadUser(username);
            ContentStreamSettings newSettings = ContentStreamSettings.builder().contentStreamEnabled(settings.contentStreamEnabled()).releasesEnabled(settings.releasesEnabled()).topics(settings.topics()).build();
            this.contentStreamService.saveUserSettings(user, newSettings);
            return newSettings;
        }
        throw new ForbiddenException("Not allowed to edit user " + username);
    }

    private User loadUser(String userName) throws NotFoundException {
        User user = this.userService.load(userName);
        if (user == null) {
            throw new NotFoundException("User " + userName + " has not been found.");
        }
        return user;
    }
}

